/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers;

import java.util.Map;
import repast.simphony.freezedry.AbstractFreezeDryer;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryedParentChild;
import repast.simphony.freezedry.FreezeDryedRegistry;
import repast.simphony.freezedry.FreezeDryingException;
import repast.simphony.util.collections.Pair;
import simphony.util.messages.MessageCenter;

public class MapFreezeDryer
extends AbstractFreezeDryer<Map<?, ?>> {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(MapFreezeDryer.class);

    public MapFreezeDryer(FreezeDryedRegistry registry) {
        super(registry);
    }

    @Override
    public FreezeDryedObject freezeDry(String id, Map<?, ?> o) throws FreezeDryingException {
        FreezeDryedObject fdo = new FreezeDryedObject(id, o.getClass());
        for (Object key : o.keySet()) {
            Pair aPair = new Pair(key, o.get(key));
            FreezeDryedParentChild child = new FreezeDryedParentChild(o.getClass(), id, Pair.class, this.registry.getId(aPair));
            fdo.addChild(child);
        }
        return fdo;
    }

    @Override
    public Map<?, ?> rehydrate(FreezeDryedObject fdo) throws FreezeDryingException {
        Class type = fdo.getType();
        try {
            Map instance = (Map)type.newInstance();
            for (FreezeDryedParentChild child : fdo.getChildren()) {
                if (Pair.class != child.getChildClass()) {
                    LOG.warn((Object)("Found an invalid child '" + child + "' in freeze dryed object (not a Pair), ignoring it and continuing."), new Object[0]);
                    continue;
                }
                Pair pair = this.registry.getObject(child.getChildId(), Pair.class);
                instance.put(pair.getFirst(), pair.getSecond());
            }
            return instance;
        }
        catch (InstantiationException e) {
            throw new FreezeDryingException(e);
        }
        catch (IllegalAccessException e) {
            throw new FreezeDryingException(e);
        }
    }

    @Override
    public boolean handles(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }
}

