/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import repast.simphony.freezedry.AbstractFreezeDryer;
import repast.simphony.freezedry.FieldUtilities;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryedParentChild;
import repast.simphony.freezedry.FreezeDryedRegistry;
import repast.simphony.freezedry.FreezeDryer;
import repast.simphony.freezedry.FreezeDryingException;
import simphony.util.messages.MessageCenter;

public class DefaultFreezeDryer
extends AbstractFreezeDryer<Object> {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(DefaultFreezeDryer.class);
    private FieldUtilities util = FieldUtilities.INSTANCE;

    public DefaultFreezeDryer(FreezeDryedRegistry registry) {
        super(registry);
    }

    @Override
    public FreezeDryedObject freezeDry(String id, Object o) throws FreezeDryingException {
        String childKey;
        Object child;
        boolean accessibility;
        Field field;
        Field[] fieldArray;
        Class type = o.getClass();
        FreezeDryedObject fdo = new FreezeDryedObject(id, type);
        type = type.getSuperclass();
        Stack superStack = new Stack();
        while (!type.equals(Object.class)) {
            superStack.push(type);
            if (!this.registry.getFreezeDryer(type).equals(this)) {
                Class parentType = (Class)superStack.pop();
                FreezeDryer<Object> dryer = this.registry.getFreezeDryer(parentType);
                FreezeDryedObject pfdo = dryer.freezeDry(UUID.randomUUID().toString(), o);
                Map<String, Object> parentProps = pfdo.getProperties();
                for (String key : parentProps.keySet()) {
                    fdo.put(String.valueOf(type.getName()) + "_" + key, parentProps.get(key));
                }
                for (FreezeDryedParentChild fdpc : pfdo.getChildren()) {
                    fdo.addChild(fdpc);
                }
                break;
            }
            type = type.getSuperclass();
        }
        while (!superStack.isEmpty()) {
            type = (Class)superStack.pop();
            fieldArray = type.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                block31: {
                    field = fieldArray[n2];
                    accessibility = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        if (Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) break block31;
                        try {
                            if (this.util.isPrimitive(field)) {
                                fdo.put(String.valueOf(type.getName()) + "_" + field.getName(), field.get(o));
                            } else if (this.util.isPrimitiveArray(field)) {
                                fdo.put(String.valueOf(type.getName()) + "_" + field.getName(), field.get(o));
                            } else {
                                child = field.get(o);
                                if (child != null) {
                                    childKey = this.registry.getId(child);
                                    fdo.put(String.valueOf(field.getName()) + "_CLASS", this.util.getTypeAsString(child));
                                    fdo.put(String.valueOf(field.getName()) + "_ID", childKey);
                                } else {
                                    fdo.put(String.valueOf(field.getName()) + "_CLASS", null);
                                    fdo.put(String.valueOf(field.getName()) + "_ID", null);
                                }
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Error writing child field '" + field + "' for '" + o + "'."), (Throwable)ex, new Object[0]);
                            throw new FreezeDryingException(ex);
                        }
                    }
                    finally {
                        field.setAccessible(accessibility);
                    }
                }
                ++n2;
            }
        }
        fieldArray = o.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n3 = 0;
        while (n3 < n) {
            block32: {
                field = fieldArray[n3];
                accessibility = field.isAccessible();
                try {
                    field.setAccessible(true);
                    if (Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) break block32;
                    try {
                        if (this.util.isPrimitive(field)) {
                            fdo.put(field.getName(), field.get(o));
                        } else if (this.util.isPrimitiveArray(field)) {
                            fdo.put(field.getName(), field.get(o));
                        } else {
                            child = field.get(o);
                            if (child != null) {
                                childKey = this.registry.getId(child);
                                fdo.put(String.valueOf(field.getName()) + "_CLASS", this.util.getTypeAsString(child));
                                fdo.put(String.valueOf(field.getName()) + "_ID", childKey);
                            } else {
                                fdo.put(String.valueOf(field.getName()) + "_CLASS", null);
                                fdo.put(String.valueOf(field.getName()) + "_ID", null);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Error writing child field '" + field + "' for '" + o + "'."), (Throwable)ex, new Object[0]);
                        throw new FreezeDryingException(ex);
                    }
                }
                finally {
                    field.setAccessible(accessibility);
                }
            }
            ++n3;
        }
        return fdo;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object rehydrate(FreezeDryedObject fdo) throws FreezeDryingException {
        try {
            block26: {
                type = fdo.getType();
                cons = null;
                instance = null;
                try {
                    cons = type.getConstructor(new Class[0]);
                    instance = cons.newInstance(new Object[0]);
                    break block26;
                }
                catch (NoSuchMethodException nsme) {
                    cons = type.getConstructors()[0];
                    params = cons.getParameterTypes();
                    paramInst = new Object[params.length];
                    i = 0;
                    ** while (i < params.length)
                }
lbl-1000:
                // 1 sources

                {
                    paramInst[i] = params[i].equals(String.class) != false ? "" : (params[i].isPrimitive() == false ? null : Integer.valueOf(0));
                    ++i;
                    continue;
                }
lbl18:
                // 1 sources

                instance = cons.newInstance(paramInst);
            }
            for (Field field : this.getFields(type)) {
                accessibility = field.isAccessible();
                try {
                    field.setAccessible(true);
                    if (Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                    if (this.util.isPrimitive(field)) {
                        val = fdo.get(field.getName());
                        if (val == null) continue;
                        if (field.getType().equals(Double.TYPE)) {
                            field.set(instance, ((Number)fdo.get(field.getName())).doubleValue());
                            continue;
                        }
                        if (field.getType().equals(Integer.TYPE)) {
                            field.set(instance, ((Number)fdo.get(field.getName())).intValue());
                            continue;
                        }
                        if (field.getType().equals(Short.TYPE)) {
                            field.set(instance, ((Number)fdo.get(field.getName())).shortValue());
                            continue;
                        }
                        if (field.getType().equals(Float.TYPE)) {
                            field.set(instance, Float.valueOf(((Number)fdo.get(field.getName())).floatValue()));
                            continue;
                        }
                        if (field.getType().equals(Byte.TYPE)) {
                            field.set(instance, ((Number)fdo.get(field.getName())).byteValue());
                            continue;
                        }
                        if (field.getType().equals(Long.TYPE)) {
                            field.set(instance, ((Number)fdo.get(field.getName())).longValue());
                            continue;
                        }
                        if (field.getType().equals(String.class)) {
                            field.set(instance, fdo.get(field.getName()));
                            continue;
                        }
                        if (field.getType().equals(Boolean.TYPE)) {
                            field.set(instance, Boolean.valueOf(fdo.get(field.getName()).toString()));
                            continue;
                        }
                        if (!field.getType().equals(Character.TYPE)) continue;
                        fdoVal = fdo.get(field.getName());
                        if (fdoVal instanceof String && ((String)fdoVal).length() > 0) {
                            fdoVal = Character.valueOf(((String)fdoVal).charAt(0));
                        }
                        field.set(instance, (Character)fdoVal);
                        continue;
                    }
                    typeName = (String)fdo.get(String.valueOf(field.getName()) + "_CLASS");
                    id = (String)fdo.get(String.valueOf(field.getName()) + "_ID");
                    if (typeName == null || id == null) continue;
                    childType = this.util.getClassFromString(typeName);
                    child = this.registry.getObject(id, childType);
                    field.set(instance, child);
                }
                finally {
                    field.setAccessible(accessibility);
                }
            }
            return instance;
        }
        catch (SecurityException e) {
            throw new FreezeDryingException(e);
        }
        catch (IllegalAccessException e) {
            throw new FreezeDryingException(e);
        }
        catch (ClassNotFoundException e) {
            throw new FreezeDryingException(e);
        }
        catch (InstantiationException ex) {
            DefaultFreezeDryer.LOG.error((Object)("Error instantiating " + fdo + "."), (Throwable)ex, new Object[0]);
            throw new FreezeDryingException("Error instantiating " + fdo + ".", ex);
        }
        catch (InvocationTargetException ex) {
            DefaultFreezeDryer.LOG.error((Object)("Error instantiating " + fdo + "."), (Throwable)ex, new Object[0]);
            throw new FreezeDryingException("Error instantiating " + fdo + ".", ex);
        }
    }

    private List<Field> getFields(Class type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (type != Object.class) {
            Field[] fieldArray = type.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                fields.add(field);
                ++n2;
            }
            type = type.getSuperclass();
        }
        return fields;
    }

    @Override
    public boolean handles(Class<?> clazz) {
        return true;
    }
}

