/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers;

import java.util.ArrayList;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.freezedry.AbstractFreezeDryer;
import repast.simphony.freezedry.FreezeDryUtils;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryedParentChild;
import repast.simphony.freezedry.FreezeDryedRegistry;
import repast.simphony.freezedry.FreezeDryingException;
import repast.simphony.freezedry.freezedryers.proj.ProjectionDryer;
import repast.simphony.space.projection.Projection;
import repast.simphony.valueLayer.ValueLayer;
import simphony.util.messages.MessageCenter;

public class ContextFreezeDryer
extends AbstractFreezeDryer<DefaultContext<?>> {
    public static final String VALUE_LAYERS_KEY = "valueLayers";
    public static final String CONTEXT_TYPE_ID_KEY = "contextTypeId";
    public static final String CONTEXT_ID_KEY = "contextId";
    public static final String PROPERTY_PROJECTIONS_KEY = "projectionsFromProperties";
    public static final String NORMAL_PROJECTIONS_KEY = "projectionsFromDefault";
    public static final String PROJECTION_TYPE_KEY = "projectionType";
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(ContextFreezeDryer.class);

    public ContextFreezeDryer(FreezeDryedRegistry registry) {
        super(registry);
    }

    @Override
    public FreezeDryedObject freezeDry(String id, DefaultContext<?> context) throws FreezeDryingException {
        FreezeDryedObject fdo = new FreezeDryedObject(context.getId().toString(), context.getClass());
        this.storeMetaData(fdo, context);
        this.storeChildren(fdo, context);
        this.storeProjections(fdo, context);
        this.storeValueLayers(fdo, context);
        this.storeSubContexts(fdo, context);
        return fdo;
    }

    private void storeSubContexts(FreezeDryedObject fdo, DefaultContext<?> context) throws FreezeDryingException {
        ArrayList subContexts = new ArrayList();
        for (Context subContext : context.getSubContexts()) {
            subContexts.add(subContext);
        }
        FreezeDryUtils.addComplex(this.registry, fdo, "subContexts", subContexts);
    }

    private void storeValueLayers(FreezeDryedObject fdo, DefaultContext<?> context) throws FreezeDryingException {
        ArrayList<ValueLayer> list = new ArrayList<ValueLayer>(context.getValueLayers());
        FreezeDryUtils.addComplex(this.registry, fdo, VALUE_LAYERS_KEY, list);
    }

    protected void storeMetaData(FreezeDryedObject fdo, DefaultContext<?> context) {
        fdo.put(CONTEXT_ID_KEY, context.getId());
        fdo.put(CONTEXT_TYPE_ID_KEY, context.getTypeID());
    }

    protected void storeChildren(FreezeDryedObject fdo, Context context) throws FreezeDryingException {
        for (Object child : context) {
            FreezeDryedParentChild cfdo = new FreezeDryedParentChild(context.getClass(), fdo.getId(), child.getClass(), this.registry.getId(child));
            fdo.addChild(cfdo);
        }
    }

    protected void storeProjections(FreezeDryedObject fdo, Context<?> context) throws FreezeDryingException {
        ArrayList<Map<String, Object>> projectionProps = new ArrayList<Map<String, Object>>();
        ArrayList normalProjections = new ArrayList();
        for (Projection<?> proj : context.getProjections()) {
            ProjectionDryer<?> dryer = ProjectionDryer.getDryer(proj.getClass());
            if (dryer == null) {
                normalProjections.add(proj);
                LOG.info((Object)("Could not find projection dryer for freeze drying projection '" + proj + "' in context '" + context + "', using the default freeze dryer."), new Object[0]);
                continue;
            }
            Map<String, Object> map = dryer.getProperties(context, proj);
            map.put(PROJECTION_TYPE_KEY, proj.getClass());
            projectionProps.add(map);
        }
        FreezeDryUtils.addComplex(this.registry, fdo, PROPERTY_PROJECTIONS_KEY, projectionProps);
        FreezeDryUtils.addComplex(this.registry, fdo, NORMAL_PROJECTIONS_KEY, normalProjections);
    }

    @Override
    public DefaultContext rehydrate(FreezeDryedObject fdo) throws FreezeDryingException {
        DefaultContext context = this.instantiate(fdo);
        this.loadMetaData(fdo, context);
        this.loadChildren(fdo, context);
        this.loadProjections(fdo, context);
        this.loadValueLayers(fdo, context);
        this.loadSubContexts(fdo, context);
        return context;
    }

    private void loadSubContexts(FreezeDryedObject fdo, DefaultContext context) throws FreezeDryingException {
        Iterable subContexts = this.getIterable(fdo, "subContexts");
        if (subContexts != null) {
            for (Object obj : subContexts) {
                if (obj instanceof Context) {
                    context.addSubContext((Context)obj);
                    continue;
                }
                LOG.warn((Object)("Found a non-context '" + obj + "' when loading sub contexts for context '" + context + "'."), new Object[0]);
            }
        }
    }

    private void loadValueLayers(FreezeDryedObject fdo, DefaultContext context) throws FreezeDryingException {
        Iterable layers = this.getIterable(fdo, VALUE_LAYERS_KEY);
        if (layers == null) {
            LOG.info((Object)("Did not find any layers for context '" + context + "'."), new Object[0]);
            return;
        }
        for (Object obj : layers) {
            if (obj instanceof ValueLayer) {
                ValueLayer valLayer = (ValueLayer)obj;
                context.addValueLayer(valLayer);
                continue;
            }
            LOG.warn((Object)("Found a non-value layer '" + obj + "' when loading value layers for context '" + context + "'."), new Object[0]);
        }
    }

    private void loadMetaData(FreezeDryedObject fdo, DefaultContext context) throws FreezeDryingException {
        String typeId = this.getString(fdo, CONTEXT_TYPE_ID_KEY);
        context.setTypeID(typeId);
    }

    protected Iterable getIterable(FreezeDryedObject fdo, String key) throws FreezeDryingException {
        return this.getVal(fdo, key, Iterable.class);
    }

    protected Projection getProjection(Object obj, String key) throws FreezeDryingException {
        return this.getVal(obj, Projection.class, key);
    }

    protected DefaultContext instantiate(FreezeDryedObject fdo) throws FreezeDryingException {
        if (fdo.get(CONTEXT_ID_KEY) == null) {
            FreezeDryingException ex = new FreezeDryingException("Could not find context id in freeze dryed object '" + fdo + "'.");
            LOG.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            throw ex;
        }
        String contextId = this.getString(fdo, CONTEXT_ID_KEY);
        return new DefaultContext(contextId);
    }

    protected void loadChildren(FreezeDryedObject fdo, DefaultContext context) throws FreezeDryingException {
        for (FreezeDryedParentChild child : fdo.getChildren()) {
            context.add(this.getChild(child));
        }
    }

    protected void loadPropertyProjections(FreezeDryedObject fdo, Context context) throws FreezeDryingException {
        Iterable propertyProjections = this.getIterable(fdo, PROPERTY_PROJECTIONS_KEY);
        if (propertyProjections == null) {
            return;
        }
        for (Object obj : propertyProjections) {
            if (obj instanceof Map) {
                Map props = (Map)obj;
                ProjectionDryer dryer = ProjectionDryer.getDryer((Class)props.get(PROJECTION_TYPE_KEY));
                if (dryer == null) {
                    LOG.warn((Object)("Could not find projection dryer for rehydrating projection with class '" + props.get(PROJECTION_TYPE_KEY) + "' in context '" + context + "'"), new Object[0]);
                    continue;
                }
                dryer.buildAndAddProjection(context, props);
                continue;
            }
            LOG.warn((Object)("Found a non-Map '" + obj + "' when attempting to load up a property projection for context '" + context + "', ignoring and continuing."), new Object[0]);
        }
    }

    protected void loadNormalProjections(FreezeDryedObject fdo, Context context) throws FreezeDryingException {
        Iterable projections = this.getIterable(fdo, NORMAL_PROJECTIONS_KEY);
        if (projections == null) {
            return;
        }
        for (Object obj : projections) {
            Projection proj = this.getProjection(obj, NORMAL_PROJECTIONS_KEY);
            if (proj == null) continue;
            context.addProjection(proj);
        }
    }

    protected void loadProjections(FreezeDryedObject fdo, Context context) throws FreezeDryingException {
        this.loadPropertyProjections(fdo, context);
        this.loadNormalProjections(fdo, context);
    }

    @Override
    public boolean handles(Class<?> clazz) {
        return DefaultContext.class.isAssignableFrom(clazz);
    }
}

