/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.freezedryers;

import java.lang.reflect.Array;
import repast.simphony.freezedry.AbstractFreezeDryer;
import repast.simphony.freezedry.FieldUtilities;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryedParentChild;
import repast.simphony.freezedry.FreezeDryedRegistry;
import repast.simphony.freezedry.FreezeDryingException;

public class ArrayFreezeDryer
extends AbstractFreezeDryer {
    protected FieldUtilities util = FieldUtilities.INSTANCE;

    public ArrayFreezeDryer(FreezeDryedRegistry registry) {
        super(registry);
    }

    @Override
    public Object rehydrate(FreezeDryedObject fdo) throws FreezeDryingException {
        String arrayType = fdo.getType().getComponentType().getName();
        int size = fdo.numChildren();
        Object array = null;
        try {
            array = Array.newInstance(FieldUtilities.INSTANCE.getClassFromString(arrayType), size);
        }
        catch (ClassNotFoundException cnfe) {
            throw new FreezeDryingException(cnfe);
        }
        try {
            for (FreezeDryedParentChild cfdo : fdo.getChildren()) {
                int index = cfdo.getIndex();
                Object child = this.getChild(cfdo);
                Array.set(array, index, child);
            }
            return array;
        }
        catch (NegativeArraySizeException e) {
            throw new FreezeDryingException(e);
        }
    }

    @Override
    public FreezeDryedObject freezeDry(String id, Object o) throws FreezeDryingException {
        FreezeDryedObject fdo = new FreezeDryedObject(id, o.getClass());
        int size = Array.getLength(o);
        int i = 0;
        while (i < size) {
            Object child = Array.get(o, i);
            if (child != null) {
                FreezeDryedParentChild cfdo = new FreezeDryedParentChild(o.getClass(), fdo.getId(), child.getClass(), this.registry.getId(child), i);
                fdo.addChild(cfdo);
            }
            ++i;
        }
        return fdo;
    }

    @Override
    public boolean handles(Class clazz) {
        return clazz.isArray();
    }
}

