/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.datasource;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringEscapeUtils;
import repast.simphony.freezedry.AbstractDataSource;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryingException;
import repast.simphony.freezedry.datasource.DFRowData;
import repast.simphony.util.SystemConstants;
import simphony.util.messages.MessageCenter;

public class DelimitedFileDataSource
extends AbstractDataSource<DFRowData> {
    public static final char DEFAULT_DELIMITER = ',';
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(DelimitedFileDataSource.class);
    protected transient HashMap<String, CSVWriter> writerMap;
    protected String path;
    protected boolean reading = false;
    private transient HashMap<String, CSVWriter> childWriters;
    private transient HashMap<String, CSVReader> typeReaders;
    private transient HashMap<String, List<String>> typeFields;
    private transient HashMap<String, CSVReader> childReaders;
    private Set<String> writtenFiles = new HashSet<String>();
    private char delimiter = (char)44;
    private String zipFileName;

    public DelimitedFileDataSource(String zipFileName) {
        this(zipFileName, ',');
    }

    public DelimitedFileDataSource(String zipFileName, char delimiter) {
        this(zipFileName, delimiter, new File(zipFileName).exists());
    }

    public DelimitedFileDataSource(String zipFileName, char delimiter, boolean read) {
        this.delimiter = delimiter;
        this.reading = read;
        this.zipFileName = zipFileName;
        if (this.reading) {
            this.unzip(zipFileName);
        } else {
            this.createDirectory(zipFileName);
        }
        this.setupMaps();
    }

    private void unzip(String zipFile) {
        int bufSize = 1024;
        try {
            ZipEntry entry;
            File file = new File(zipFile);
            this.createDirectory(file.getParentFile().getAbsolutePath());
            ZipInputStream in = new ZipInputStream(new FileInputStream(zipFile));
            File parent = new File(this.path);
            while ((entry = in.getNextEntry()) != null) {
                int len;
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(parent, entry.getName())), bufSize);
                byte[] buf = new byte[bufSize];
                while ((len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
                out.close();
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createDirectory(String zipFileName) {
        int index = 0;
        File f = new File(zipFileName);
        String parentPath = f.getParentFile().getAbsolutePath();
        String pathName = String.valueOf(parentPath) + File.separator + "tmp_" + index++;
        f = new File(pathName);
        while (f.exists()) {
            pathName = String.valueOf(parentPath) + File.separator + "tmp_" + index++;
            f = new File(pathName);
        }
        f.mkdirs();
        this.path = f.getAbsolutePath();
    }

    @Override
    public void reset() {
    }

    @Override
    public void close() throws FreezeDryingException {
        try {
            if (!this.reading) {
                File zipFile;
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HH_mm_ss");
                String tmp = this.zipFileName;
                if (tmp.endsWith(".zip")) {
                    tmp = tmp.substring(0, tmp.length() - 4);
                }
                if (!(zipFile = new File(new File(this.path).getParentFile(), String.valueOf(new File(tmp).getName()) + "_" + format.format(new Date()) + ".zip")).exists()) {
                    zipFile.createNewFile();
                }
                byte[] buf = new byte[1024];
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
                for (String path : this.writtenFiles) {
                    int len;
                    File file = new File(path);
                    FileInputStream in = new FileInputStream(file);
                    out.putNextEntry(new ZipEntry(file.getName()));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                out.close();
            }
            File dir = new File(this.path);
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            dir.delete();
        }
        catch (IOException ex) {
            throw new FreezeDryingException("Error while zipping freezedry files", ex);
        }
    }

    private void setupMaps() {
        this.writerMap = new HashMap();
        this.childWriters = new HashMap();
        this.typeReaders = new HashMap();
        this.typeFields = new HashMap();
        this.childReaders = new HashMap();
    }

    @Override
    protected void startTypeRead(Class clazz) throws FreezeDryingException {
        this.setupMaps();
        CSVReader reader = this.getReader(this.getType(clazz));
        try {
            String[] line = reader.readNext();
            if (line == null) {
                throw new FreezeDryingException("Empty Data Source");
            }
            List<String> fields = this.buildHeader(line);
            this.typeFields.put(this.getType(clazz), fields);
        }
        catch (IOException ex) {
            throw new FreezeDryingException(ex);
        }
    }

    @Override
    protected DFRowData readRow(Class clazz, String key) throws FreezeDryingException {
        String[] line;
        block3: {
            try {
                line = this.typeReaders.get(this.getType(clazz)).readNext();
                if (line != null) break block3;
                return null;
            }
            catch (IOException ex) {
                throw new FreezeDryingException(ex);
            }
        }
        return new DFRowData(line, 0);
    }

    protected CSVReader getReader(String className) throws FreezeDryingException {
        try {
            if (this.typeReaders.get(className) == null) {
                File file = new File(String.valueOf(this.path) + File.separator + className);
                if (!file.exists()) {
                    file = new File(String.valueOf(this.path) + File.separator + className + ".csv");
                }
                CSVReader reader = new CSVReader((Reader)new BufferedReader(new FileReader(file)), this.delimiter);
                this.typeReaders.put(className, reader);
            }
            return this.typeReaders.get(className);
        }
        catch (IOException ex) {
            throw new FreezeDryingException(ex);
        }
    }

    @Override
    protected void endTypeRead(Class clazz) {
        try {
            try {
                if (this.typeReaders.containsKey(clazz.getName())) {
                    this.typeReaders.get(clazz.getName()).close();
                }
            }
            catch (IOException ex) {
                LOG.warn((Object)("Exception when finishing type read on class '" + clazz + "'."), (Throwable)ex, new Object[0]);
                this.typeReaders.remove(clazz.getName());
            }
        }
        finally {
            this.typeReaders.remove(clazz.getName());
        }
    }

    protected Object convert(String field, String val) {
        if (val.startsWith("\"")) {
            return this.readString(val);
        }
        return this.readNonString(val);
    }

    @Override
    protected void startTypeWrite(FreezeDryedObject object) throws FreezeDryingException {
        this.setupMaps();
        String type = this.getType(object);
        try {
            if (!this.writerMap.containsKey(type)) {
                CSVWriter writer;
                File file = new File(String.valueOf(this.path) + File.separator + type + ".csv");
                if (file.exists()) {
                    writer = new CSVWriter((Writer)new FileWriter(file, true), this.delimiter, '\"', SystemConstants.LINE_SEPARATOR);
                } else {
                    file.createNewFile();
                    this.writtenFiles.add(file.getAbsolutePath());
                    writer = new CSVWriter((Writer)new FileWriter(file), this.delimiter, '\"', SystemConstants.LINE_SEPARATOR);
                    List<String> cols = this.getColumns(object);
                    String[] array = new String[cols.size()];
                    writer.writeNext(cols.toArray(array));
                }
                this.writerMap.put(type, writer);
            }
        }
        catch (IOException ex) {
            throw new FreezeDryingException("Error writing type to file '" + this.path + File.separator + type + "'", ex);
        }
    }

    @Override
    protected void writeRow(FreezeDryedObject object, Map<String, Object> row) throws FreezeDryingException {
        CSVWriter writer = this.writerMap.get(this.getType(object));
        List<String> cols = this.getColumns(object);
        try {
            String[] array = new String[cols.size()];
            int i = 0;
            while (i < cols.size()) {
                array[i] = row.get(cols.get(i)).toString();
                ++i;
            }
            writer.writeNext(array);
        }
        catch (Exception ex) {
            throw new FreezeDryingException(ex);
        }
    }

    @Override
    protected void finishTypeWrite(FreezeDryedObject object) throws FreezeDryingException {
        if (this.writerMap.containsKey(this.getType(object))) {
            CSVWriter writer = this.writerMap.get(this.getType(object));
            try {
                writer.close();
            }
            catch (IOException ex) {
                throw new FreezeDryingException(ex);
            }
            this.writerMap.remove(this.getType(object));
        } else {
            LOG.warn((Object)("Finishing a write on type '" + this.getType(object) + "' when it appears the write hasn't started."), new Object[0]);
        }
    }

    public List<String> buildHeader(String[] header) {
        return Arrays.asList(header);
    }

    @Override
    protected Object getFieldValue(DFRowData row, String field) {
        try {
            String val = row.nextString();
            if (val.startsWith("'") || val.startsWith("\"")) {
                return this.readString(val);
            }
            return this.readNonString(val);
        }
        catch (RuntimeException ex) {
            LOG.info((Object)("Error fetching field value for field '" + field + "' and row '" + row + "'"), new Object[]{ex});
            throw ex;
        }
    }

    private String readString(String unprocessed) {
        String value = unprocessed.substring(1, unprocessed.length() - 1);
        return StringEscapeUtils.unescapeJava((String)value);
    }

    private Object readNonString(String unprocessed) {
        if (unprocessed.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (unprocessed.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return Double.parseDouble(unprocessed);
    }

    @Override
    protected void startChildrenRead(FreezeDryedObject fdo) throws FreezeDryingException {
        try {
            if (!this.childReaders.containsKey(this.getType(fdo))) {
                File file = new File(String.valueOf(this.path) + File.separator + fdo.getType().getName() + "_CHILDREN");
                if (!file.exists()) {
                    return;
                }
                CSVReader reader = new CSVReader((Reader)new BufferedReader(new FileReader(file)));
                reader.readNext();
                this.childReaders.put(this.getType(fdo), reader);
            }
        }
        catch (IOException ex) {
            this.childReaders.remove(this.getType(fdo));
            throw new FreezeDryingException(ex);
        }
    }

    @Override
    protected DFRowData readChildsRow(FreezeDryedObject parent, String id) throws FreezeDryingException {
        String[] line;
        block5: {
            block4: {
                try {
                    if (this.childReaders.containsKey(this.getType(parent))) break block4;
                    return null;
                }
                catch (IOException ex) {
                    throw new FreezeDryingException(ex);
                }
            }
            CSVReader reader = this.childReaders.get(this.getType(parent));
            line = reader.readNext();
            if (line != null) break block5;
            return null;
        }
        return new DFRowData(line, 0);
    }

    @Override
    protected void finishChildrenRead(FreezeDryedObject parent) {
        try {
            try {
                if (this.childReaders.containsKey(this.getType(parent))) {
                    this.childReaders.get(this.getType(parent)).close();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Error while reading children for parent '" + parent + "'. Not loading any children for this object."), new Object[0]);
                this.childReaders.remove(this.getType(parent));
            }
        }
        finally {
            this.childReaders.remove(this.getType(parent));
        }
    }

    @Override
    protected String writeByteArray(FreezeDryedObject object, String fieldName, byte[] bs) throws FreezeDryingException {
        String id = object.getId();
        String fileName = String.valueOf(this.path) + File.separator + id + "_" + fieldName + ".ser";
        OutputStream os = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
                this.writtenFiles.add(file.getAbsolutePath());
            }
            os = new FileOutputStream(file);
            os.write(bs);
            String string = fileName;
            return string;
        }
        catch (IOException e) {
            throw new FreezeDryingException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new FreezeDryingException(e);
                }
            }
        }
    }

    @Override
    protected byte[] readByteArray(FreezeDryedObject fdo, String field, Object bytesId) throws FreezeDryingException {
        String unprocessed = (String)bytesId;
        String fileName = unprocessed.substring(1, unprocessed.length() - 1);
        InputStream os = null;
        byte[] ba = null;
        try {
            try {
                File file = new File(fileName);
                os = new FileInputStream(file);
                ba = new byte[(int)file.length()];
                os.read(ba);
            }
            catch (IOException e) {
                throw new FreezeDryingException(e);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new FreezeDryingException(e);
                }
            }
        }
        return ba;
    }

    @Override
    protected void startChildrenWrite(FreezeDryedObject fdo) throws FreezeDryingException {
        File file = new File(String.valueOf(this.path) + File.separator + this.getType(fdo) + "_CHILDREN");
        CSVWriter writer = null;
        try {
            if (this.childWriters.containsKey(this.getType(fdo))) {
                return;
            }
            if (file.exists()) {
                writer = new CSVWriter((Writer)new FileWriter(file, true), this.delimiter, '\"', SystemConstants.LINE_SEPARATOR);
            } else {
                file.createNewFile();
                this.writtenFiles.add(file.getAbsolutePath());
                writer = new CSVWriter((Writer)new FileWriter(file), this.delimiter, '\"', SystemConstants.LINE_SEPARATOR);
                writer.writeNext(new String[]{"parentid", "childclass", "childid"});
            }
            this.childWriters.put(this.getType(fdo), writer);
        }
        catch (IOException ex) {
            LOG.error((Object)("Error beginning write of children for '" + fdo + "'."), (Throwable)ex, new Object[0]);
            throw new FreezeDryingException(ex);
        }
    }

    @Override
    protected void writeChildData(FreezeDryedObject fdo, HashMap<String, Object> child) throws FreezeDryingException {
        CSVWriter writer = this.childWriters.get(this.getType(fdo));
        try {
            writer.writeNext(new String[]{this.getValue(child.get("parentid").toString()).toString(), this.getValue(child.get("childclass").toString()).toString(), this.getValue(child.get("childid").toString()).toString()});
        }
        catch (Exception ex) {
            LOG.error((Object)("Error writing child data for '" + fdo + "', child='" + child + "'."), (Throwable)ex, new Object[0]);
            throw new FreezeDryingException(ex);
        }
    }

    @Override
    protected void finishChildrenWrite(FreezeDryedObject fdo) {
        CSVWriter writer = this.childWriters.get(this.getType(fdo));
        try {
            if (writer != null) {
                this.childWriters.remove(this.getType(fdo));
                writer.close();
            }
        }
        catch (IOException ex) {
            LOG.warn((Object)("Error closing children file for '" + fdo + "'."), (Throwable)ex, new Object[0]);
        }
    }

    @Override
    protected List<String> getFields(String type) {
        return this.typeFields.get(type);
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getPath() {
        return this.path;
    }
}

