/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry.datasource;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DFClassLister {
    private String zipFileName;

    public DFClassLister(String zipFileName) {
        this.zipFileName = zipFileName;
    }

    public List<Class<?>> getClasses() throws ClassNotFoundException, IOException {
        ArrayList classList = new ArrayList();
        File file = new File(this.zipFileName);
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            Class clazz;
            ZipEntry zipEntry = e.nextElement();
            String entryName = zipEntry.getName();
            String name = this.getClassName(entryName);
            if (entryName.startsWith(".") || entryName.endsWith("_CHILDREN")) continue;
            if (name.equals("[D")) {
                clazz = double[].class;
            } else if (name.equals("[I")) {
                clazz = int[].class;
            } else if (name.equals("[J")) {
                clazz = long[].class;
            } else if (name.startsWith("[L")) {
                Class<?> compClass = Class.forName(name.substring(2, name.length() - 1));
                clazz = Array.newInstance(compClass, 1).getClass();
            } else {
                clazz = this.getClass().getClassLoader().loadClass(name);
            }
            classList.add(clazz);
        }
        return classList;
    }

    protected String getClassName(String name) {
        if (name.endsWith(".csv")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }
}

