/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry;

import repast.simphony.freezedry.AbstractFreezeDryer;
import repast.simphony.freezedry.ArrayValueHandler;
import repast.simphony.freezedry.FieldUtilities;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryedRegistry;
import repast.simphony.freezedry.FreezeDryingException;

public class PrimitiveArrayFreezeDryer
extends AbstractFreezeDryer {
    public static final char ELEMENT_DELIMITER = ',';
    public static final String ELEMENTS_KEY = "elements";
    protected FieldUtilities util = FieldUtilities.INSTANCE;

    public PrimitiveArrayFreezeDryer(FreezeDryedRegistry registry) {
        super(registry);
    }

    @Override
    public Object rehydrate(FreezeDryedObject fdo) throws FreezeDryingException {
        String arrayType = fdo.getType().getName();
        return ArrayValueHandler.readArray(arrayType, (String)fdo.get(ELEMENTS_KEY), ',');
    }

    @Override
    public FreezeDryedObject freezeDry(String id, Object o) throws FreezeDryingException {
        FreezeDryedObject fdo = new FreezeDryedObject(id, o.getClass());
        fdo.put(ELEMENTS_KEY, ArrayValueHandler.writeArray(o, ','));
        return fdo;
    }

    protected boolean isType(Class clazz, Class type) {
        return clazz.equals(type);
    }

    @Override
    public boolean handles(Class type) {
        return FieldUtilities.INSTANCE.isPrimitiveArray(type);
    }
}

