/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import repast.simphony.context.Context;
import repast.simphony.engine.environment.ProjectionRegistry;
import repast.simphony.engine.environment.ProjectionRegistryData;
import repast.simphony.freezedry.FreezeDryedDataSource;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryer;
import repast.simphony.freezedry.FreezeDryingException;
import repast.simphony.freezedry.PrimitiveArrayFreezeDryer;
import repast.simphony.freezedry.freezedryers.AmountFreezeDryer;
import repast.simphony.freezedry.freezedryers.ArrayFreezeDryer;
import repast.simphony.freezedry.freezedryers.BigDecimalFreezeDryer;
import repast.simphony.freezedry.freezedryers.ClassFreezeDryer;
import repast.simphony.freezedry.freezedryers.CollectionFreezeDryer;
import repast.simphony.freezedry.freezedryers.ContextFreezeDryer;
import repast.simphony.freezedry.freezedryers.DefaultFreezeDryer;
import repast.simphony.freezedry.freezedryers.MapFreezeDryer;
import repast.simphony.freezedry.freezedryers.PrimitiveFreezeDryer;
import simphony.util.messages.MessageCenter;

public class FreezeDryedRegistry {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(FreezeDryedRegistry.class);
    private transient Map<String, Object> keyCache = new HashMap<String, Object>();
    private transient Map<Object, String> objectCache = new HashMap<Object, String>();
    private FreezeDryer defaultDryer = new DefaultFreezeDryer(this);
    private Map<Class<?>, FreezeDryer<?>> freezerMap = new HashMap();
    private LinkedList<FreezeDryer> driers = new LinkedList();
    private FreezeDryedDataSource dataSource;

    public FreezeDryedRegistry() {
        this.driers.add(new PrimitiveFreezeDryer());
        this.driers.add(new PrimitiveArrayFreezeDryer(this));
        this.driers.add(new ArrayFreezeDryer(this));
        this.driers.add(new ContextFreezeDryer(this));
        this.driers.add(new MapFreezeDryer(this));
        this.driers.add(new CollectionFreezeDryer(this));
        this.driers.add(new ClassFreezeDryer(this));
        this.driers.add(new AmountFreezeDryer());
        this.driers.add(new BigDecimalFreezeDryer());
        for (ProjectionRegistryData data : ProjectionRegistry.getRegistryData()) {
            this.driers.addAll(data.getFreezeDryers());
        }
    }

    public String getId(Object o) throws FreezeDryingException {
        String id = this.objectCache.get(o);
        if (id == null) {
            id = this.freezeDryObject(o);
        }
        return id;
    }

    public <T> T getObject(String key, Class<T> type) throws FreezeDryingException {
        Object object = this.keyCache.get(key);
        if (object == null) {
            object = this.rehydrateObject(type, key);
            this.keyCache.put(key, object);
            return (T)object;
        }
        return (T)object;
    }

    public void setDataSource(FreezeDryedDataSource dataSource) {
        this.dataSource = dataSource;
    }

    private <T> T rehydrateObject(Class<T> type, String key) throws FreezeDryingException {
        try {
            FreezeDryedObject fdo = this.dataSource.read(type, key);
            FreezeDryer<T> dryer = this.getFreezeDryer(type);
            return dryer.rehydrate(fdo);
        }
        catch (RuntimeException ex) {
            LOG.error((Object)("Error while attempting to rehydrate class '" + type + "' with key '" + key + "'."), (Throwable)ex, new Object[0]);
            throw ex;
        }
    }

    public <T> T rehydrate(Class<T> type, String key) throws FreezeDryingException {
        T result = this.rehydrateObject(type, key);
        this.dataSource.close();
        return result;
    }

    public <T> Collection<T> rehydrate(Class<T> type) throws FreezeDryingException {
        ArrayList<T> objects = new ArrayList<T>();
        Iterable<FreezeDryedObject> fdos = this.dataSource.read(type);
        FreezeDryer<T> dryer = this.getFreezeDryer(type);
        for (FreezeDryedObject fdo : fdos) {
            objects.add(dryer.rehydrate(fdo));
        }
        return objects;
    }

    public String freezeDry(Object obj) throws FreezeDryingException {
        String retVal = this.freezeDryObject(obj);
        this.dataSource.close();
        return retVal;
    }

    private String freezeDryObject(Object o) throws FreezeDryingException {
        String key = o instanceof Context ? ((Context)o).getId().toString() : this.generateObjectKey().toString();
        this.keyCache.put(key, o);
        this.objectCache.put(o, key);
        FreezeDryer<?> dryer = this.getFreezeDryer(o.getClass());
        FreezeDryedObject fdo = dryer.freezeDry(key, o);
        this.dataSource.write(fdo);
        return key;
    }

    public <T> FreezeDryer<T> getFreezeDryer(Class<T> type) {
        FreezeDryer<?> registeredDryer = this.freezerMap.get(type);
        if (registeredDryer != null) {
            return registeredDryer;
        }
        for (FreezeDryer dryer : this.driers) {
            if (!dryer.handles(type)) continue;
            return dryer;
        }
        return this.defaultDryer;
    }

    public void registerFreezeDryer(Class clazz, FreezeDryer dryer) {
        this.freezerMap.put(clazz, dryer);
    }

    public String generateObjectKey() {
        return UUID.randomUUID().toString();
    }

    public void reset() {
        this.objectCache.clear();
        this.keyCache.clear();
    }
}

