/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;

public class FieldUtilities {
    public static FieldUtilities INSTANCE = new FieldUtilities();
    private HashMap<String, Class> primitiveMap = new HashMap();

    private FieldUtilities() {
        this.addPrimitiveType(Integer.TYPE);
        this.addPrimitiveType(Byte.TYPE);
        this.addPrimitiveType(Double.TYPE);
        this.addPrimitiveType(Float.TYPE);
        this.addPrimitiveType(Long.TYPE);
        this.addPrimitiveType(Short.TYPE);
        this.addPrimitiveType(Character.TYPE);
        this.addPrimitiveType(Boolean.TYPE);
        this.addPrimitiveType(String.class);
        this.addPrimitiveType(Integer.class);
        this.addPrimitiveType(Byte.class);
        this.addPrimitiveType(Double.class);
        this.addPrimitiveType(Float.class);
        this.addPrimitiveType(Long.class);
        this.addPrimitiveType(Short.class);
        this.addPrimitiveType(Character.class);
        this.addPrimitiveType(Boolean.class);
    }

    private void addPrimitiveType(Class clazz) {
        this.primitiveMap.put(clazz.getName(), clazz);
    }

    public boolean isPrimitive(Field field) {
        return this.primitiveMap.containsValue(field.getType());
    }

    public boolean isPrimitive(String className) {
        return this.primitiveMap.containsKey(className);
    }

    public boolean isPrimitive(Class<?> clazz) {
        return this.primitiveMap.containsValue(clazz);
    }

    public boolean isPrimitiveArray(Field field) {
        return this.isPrimitiveArray(field.getType());
    }

    public boolean isPrimitiveArray(String className) {
        return className.length() == 2 && className.startsWith("[");
    }

    public boolean isPrimitiveArray(Class<?> clazz) {
        return clazz.isArray() && this.primitiveMap.containsValue(clazz.getComponentType());
    }

    public String getTypeAsString(Object o) {
        String type = o.getClass().isArray() ? String.valueOf(o.getClass().getComponentType().getName()) + "_ARRAY" : o.getClass().getName();
        return type;
    }

    public Class getClassFromString(String string) throws ClassNotFoundException {
        if (string.endsWith("_ARRAY")) {
            String componentName = string.substring(0, string.indexOf("_ARRAY"));
            Class componentType = this.getClassFromString(componentName);
            Object o = Array.newInstance(componentType, 0);
            return o.getClass();
        }
        if (this.isPrimitive(string)) {
            return this.primitiveMap.get(string);
        }
        return Class.forName(string);
    }
}

