/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry;

import repast.simphony.context.Context;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.freezedry.FreezeDryedDataSource;
import repast.simphony.freezedry.FreezeDryedRegistry;
import repast.simphony.freezedry.FreezeDryingException;
import simphony.util.messages.MessageCenter;

public class ContextFreezeDryingAction
implements IAction {
    public static final Object USE_ROOT_ID = "_useRootContext_";
    private static final long serialVersionUID = -275222637255697926L;
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(ContextFreezeDryingAction.class);
    protected Object contextId;
    protected transient FreezeDryedRegistry registry;
    protected FreezeDryedDataSource dataSource;

    public ContextFreezeDryingAction(Object contextId, FreezeDryedDataSource dataSource) {
        this.contextId = contextId;
        this.dataSource = dataSource;
    }

    public ContextFreezeDryingAction(FreezeDryedDataSource dataSource) {
        this(USE_ROOT_ID, dataSource);
    }

    @Override
    public void execute() {
        Context context;
        if (this.registry == null) {
            this.registry = new FreezeDryedRegistry();
            this.registry.setDataSource(this.dataSource);
        }
        if (this.contextId.equals(USE_ROOT_ID)) {
            context = RunState.getInstance().getMasterContext();
            if (context == null) {
                LOG.warn((Object)"Appears no master context exists, cannot freezedry it.", new Object[0]);
                return;
            }
        } else {
            context = RunState.getInstance().getMasterContext().findContext(this.contextId);
            if (context == null) {
                LOG.warn((Object)("Could not find a context with the specified id '" + this.contextId + "', cannot" + " freezedry it."), new Object[0]);
                return;
            }
        }
        try {
            this.registry.reset();
            this.registry.freezeDry(context);
        }
        catch (FreezeDryingException e) {
            LOG.warn((Object)("Error freeze drying context with id '" + this.contextId + "'."), (Throwable)e, new Object[0]);
        }
    }

    public FreezeDryedDataSource getDataSource() {
        return this.dataSource;
    }
}

