/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry;

import java.lang.reflect.Array;
import java.util.ArrayList;
import repast.simphony.freezedry.FieldUtilities;
import simphony.util.messages.MessageCenter;

public enum ArrayValueHandler {
    DOUBLE(new String[]{double[].class.getName(), Double[].class.getName()}){

        @Override
        public Object getValue(String value) {
            return Double.valueOf(value.trim());
        }
    }
    ,
    FLOAT(new String[]{float[].class.getName(), Float[].class.getName()}){

        @Override
        public Object getValue(String value) {
            return Integer.valueOf(value.trim());
        }
    }
    ,
    INTEGER(new String[]{int[].class.getName(), Integer[].class.getName()}){

        @Override
        public Object getValue(String value) {
            return Integer.valueOf(value.trim());
        }
    }
    ,
    BOOLEAN(new String[]{boolean[].class.getName(), Boolean[].class.getName()}){

        @Override
        public Object getValue(String value) {
            return Boolean.valueOf(value.trim());
        }
    }
    ,
    CHARACTER(new String[]{char[].class.getName(), Character[].class.getName()}){

        @Override
        public Object getValue(String value) {
            if (value.length() > 1) {
                LOG.warn((Object)("Reading in a character and the string representing it '" + value + "' is longer than 1, only the first character will be used."), new Object[0]);
            }
            if (value.length() == 0) {
                LOG.warn((Object)"Reading in a character and the string representing it has length 0, returning null.", new Object[0]);
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }
    }
    ,
    LONG(new String[]{long[].class.getName(), Long[].class.getName()}){

        @Override
        public Object getValue(String value) {
            return Long.valueOf(value.trim());
        }
    }
    ,
    SHORT(new String[]{short[].class.getName(), Short[].class.getName()}){

        @Override
        public Object getValue(String value) {
            return Short.valueOf(value.trim());
        }
    }
    ,
    STRING(new String[]{String[].class.getName()}){

        @Override
        public Object getValue(String value) {
            return value;
        }
    };

    private static final MessageCenter LOG;
    private String[] arrayTypes;

    static {
        LOG = MessageCenter.getMessageCenter(ArrayValueHandler.class);
    }

    public abstract Object getValue(String var1);

    public Object createArray(String arrayType, int size) {
        try {
            return Array.newInstance(FieldUtilities.INSTANCE.getClassFromString(arrayType).getComponentType(), size);
        }
        catch (NegativeArraySizeException e) {
            LOG.warn((Object)"Cannot pass in a negative array size, returning null.", (Throwable)e, new Object[0]);
            return null;
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("Unsupported array type '" + arrayType + "' specified, returning null."), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private ArrayValueHandler(String ... arrayTypes) {
        this.arrayTypes = arrayTypes;
    }

    public boolean handles(String arrayType) {
        int i = 0;
        while (i < this.arrayTypes.length) {
            if (this.arrayTypes[i].equals(arrayType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ArrayValueHandler getHandler(String arrayType) {
        ArrayValueHandler[] arrayValueHandlerArray = ArrayValueHandler.values();
        int n = arrayValueHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayValueHandler handler = arrayValueHandlerArray[n2];
            if (handler.handles(arrayType)) {
                return handler;
            }
            ++n2;
        }
        return null;
    }

    public static Object readArray(String arrayType, String arrayString, char delimiter) {
        ArrayList<Object> values = new ArrayList<Object>();
        boolean isStringArray = STRING.handles(arrayType);
        boolean inString = false;
        ArrayValueHandler handler = ArrayValueHandler.getHandler(arrayType);
        if (handler == null) {
            LOG.warn((Object)("Unsupported array type specified '" + arrayType + "', returning null."), new Object[0]);
            return null;
        }
        boolean escaped = false;
        int start = 0;
        int i = 0;
        try {
            i = 0;
            while (i < arrayString.length()) {
                if (isStringArray) {
                    if (i == 0) {
                        start = arrayString.indexOf(34) + 1;
                        i = start - 1;
                        inString = true;
                    } else {
                        if (inString && !escaped && arrayString.charAt(i) == '\"') {
                            values.add(handler.getValue(arrayString.substring(start, i).replace("\\\"", "\"")));
                            inString = false;
                            i = arrayString.indexOf(delimiter, i);
                            if (i < 0) {
                                break;
                            }
                        } else if (!escaped && arrayString.charAt(i) == '\"') {
                            escaped = false;
                            inString = true;
                            start = i + 1;
                        }
                        escaped = !escaped && arrayString.charAt(i) == '\\';
                    }
                } else if (arrayString.charAt(i) == delimiter) {
                    values.add(handler.getValue(arrayString.substring(start, i)));
                    start = i + 1;
                }
                ++i;
            }
            if (!isStringArray) {
                values.add(handler.getValue(arrayString.substring(start)));
            }
        }
        catch (RuntimeException ex) {
            LOG.error((Object)("Error while reading string near char " + i + " in string '" + arrayString + "'"), (Throwable)ex, new Object[0]);
            throw ex;
        }
        Object array = handler.createArray(arrayType, values.size());
        i = 0;
        while (i < values.size()) {
            Array.set(array, i, values.get(i));
            ++i;
        }
        return array;
    }

    public static String writeArray(Object array, char delimiter) {
        boolean isString = array instanceof String[];
        int len = Array.getLength(array);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < len) {
            if (i != 0) {
                builder.append(String.valueOf(delimiter) + " ");
            }
            if (isString) {
                builder.append("\"");
                builder.append(((String)Array.get(array, i)).replace("\"", "\\\""));
                builder.append("\"");
            } else {
                builder.append(Array.get(array, i));
            }
            ++i;
        }
        return builder.toString();
    }

    /* synthetic */ ArrayValueHandler(String string, int n, String[] stringArray, ArrayValueHandler arrayValueHandler) {
        this(stringArray);
    }
}

