/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.freezedry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringEscapeUtils;
import repast.simphony.freezedry.ArrayValueHandler;
import repast.simphony.freezedry.FieldUtilities;
import repast.simphony.freezedry.FreezeDryUtils;
import repast.simphony.freezedry.FreezeDryedDataSource;
import repast.simphony.freezedry.FreezeDryedObject;
import repast.simphony.freezedry.FreezeDryedParentChild;
import repast.simphony.freezedry.FreezeDryingException;
import simphony.util.messages.MessageCenter;

public abstract class AbstractDataSource<X>
implements FreezeDryedDataSource {
    public static final String SPECIAL_COL_MARKER = "_SCM_";
    public static final String CHILDREN_MARKER = "_CHILDREN";
    public static final String BYTES_MARKER = "_BYTESSTORAGE";
    public static final String CLASS_MARKER = "_CLASS";
    public static final String CHILD_ID_MARKER = "_ID";
    public static final String ID_COL = "_SCM_OBJ_ID";
    public static final String PARENT_ID_COL = "parentid";
    public static final String CHILD_CLASS_COL = "childclass";
    public static final String CHILD_ID_COL = "childid";
    public static final String ARRAY_MARKER = "ARRAY";
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(AbstractDataSource.class);

    protected abstract void startTypeWrite(FreezeDryedObject var1) throws FreezeDryingException;

    protected abstract void writeRow(FreezeDryedObject var1, Map<String, Object> var2) throws FreezeDryingException;

    protected abstract Object writeByteArray(FreezeDryedObject var1, String var2, byte[] var3) throws FreezeDryingException;

    protected abstract void startChildrenWrite(FreezeDryedObject var1) throws FreezeDryingException;

    protected abstract void writeChildData(FreezeDryedObject var1, HashMap<String, Object> var2) throws FreezeDryingException;

    protected abstract void finishChildrenWrite(FreezeDryedObject var1) throws FreezeDryingException;

    protected abstract void finishTypeWrite(FreezeDryedObject var1) throws FreezeDryingException;

    protected abstract void startTypeRead(Class var1) throws FreezeDryingException;

    protected abstract X readRow(Class var1, String var2) throws FreezeDryingException;

    protected abstract byte[] readByteArray(FreezeDryedObject var1, String var2, Object var3) throws FreezeDryingException;

    protected abstract List<String> getFields(String var1) throws FreezeDryingException;

    protected abstract Object getFieldValue(X var1, String var2) throws FreezeDryingException;

    protected abstract void startChildrenRead(FreezeDryedObject var1) throws FreezeDryingException;

    protected abstract X readChildsRow(FreezeDryedObject var1, String var2) throws FreezeDryingException;

    protected abstract void finishChildrenRead(FreezeDryedObject var1);

    protected abstract void endTypeRead(Class var1);

    @Override
    public void reset() {
    }

    @Override
    public void close() throws FreezeDryingException {
    }

    @Override
    public void write(FreezeDryedObject object) throws FreezeDryingException {
        this.startTypeWrite(object);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String[] pairs : this.getColumnKeysetPairs(object)) {
            Object value = object.get(pairs[0]);
            if (pairs[0] == ID_COL) {
                value = this.getValue(object.getId());
            } else if (value instanceof String) {
                value = this.getValue((String)value);
            } else if (value instanceof char[]) {
                value = this.getValue((char[])value);
            } else if (value instanceof Number) {
                value = this.getValue((Number)value);
            } else if (value instanceof byte[]) {
                value = this.writeByteArray(object, pairs[0], (byte[])value);
            } else if (value != null && FieldUtilities.INSTANCE.isPrimitiveArray(value.getClass())) {
                value = this.getValueArray(value);
            }
            if (value == null) continue;
            values.put(pairs[1], value);
        }
        if (object.hasChildren()) {
            values.put(this.getChildrenColumnName(object), this.getChildrenName(object));
            this.writeChildren(object);
        }
        this.writeRow(object, values);
        this.finishTypeWrite(object);
    }

    protected String getValueArray(Object value) {
        return "'" + ArrayValueHandler.writeArray(value, ',') + "'";
    }

    private Object getChildrenName(FreezeDryedObject object) {
        return this.getValue(String.valueOf(this.getType(object)) + CHILDREN_MARKER);
    }

    protected void writeChildren(FreezeDryedObject fdo) throws FreezeDryingException {
        this.startChildrenWrite(fdo);
        HashMap<String, Object> child = new HashMap<String, Object>();
        for (FreezeDryedParentChild cfdo : fdo.getChildren()) {
            child.put(PARENT_ID_COL, fdo.getId());
            child.put(CHILD_CLASS_COL, cfdo.getChildClass().getName());
            child.put(CHILD_ID_COL, cfdo.getChildId());
            this.writeChildData(fdo, child);
        }
        this.finishChildrenWrite(fdo);
    }

    protected String getType(Class clazz) {
        return clazz.getName();
    }

    protected String getType(FreezeDryedObject object) {
        return this.getType(object.getType());
    }

    protected String getValue(String value) {
        return "\"" + StringEscapeUtils.escapeJava((String)value) + "\"";
    }

    protected String getValue(char[] value) {
        return this.getValue(new String(value));
    }

    protected String getValue(Number number) {
        return number.toString();
    }

    protected List<String> getColumns(FreezeDryedObject fdo) {
        ArrayList<String> fields = new ArrayList<String>();
        for (String[] name : this.getColumnKeysetPairs(fdo)) {
            fields.add(name[1]);
        }
        return fields;
    }

    protected String[] pair(String string1, String string2) {
        return new String[]{string1, string2};
    }

    protected List<String[]> getColumnKeysetPairs(FreezeDryedObject fdo) {
        ArrayList<String[]> fields = new ArrayList<String[]>();
        fields.add(this.pair(ID_COL, ID_COL));
        for (String name : fdo.keySet()) {
            if (fdo.get(name) instanceof String || FieldUtilities.INSTANCE.isPrimitive(fdo.get(name).getClass())) {
                fields.add(this.pair(name, name));
                continue;
            }
            if (FieldUtilities.INSTANCE.isPrimitiveArray(fdo.get(name).getClass())) {
                fields.add(this.pair(name, SPECIAL_COL_MARKER + name + ARRAY_MARKER + fdo.get(name).getClass().getName()));
                LOG.info((Object)("Found array with name='" + name + "'"), new Object[0]);
                continue;
            }
            if (fdo.get(name) instanceof byte[]) {
                fields.add(this.pair(name, SPECIAL_COL_MARKER + name + BYTES_MARKER));
                continue;
            }
            if (fdo.get(name) instanceof FreezeDryedParentChild) {
                fields.add(this.pair(name, FreezeDryUtils.getClassColumn(name)));
                fields.add(this.pair(name, FreezeDryUtils.getIDColumn(name)));
                continue;
            }
            LOG.warn((Object)("Unsupported field '" + name + "' in freeze dryed object's fields. Type '" + fdo.get(name).getClass().getName() + "' not handled"), new Object[0]);
        }
        if (fdo.hasChildren()) {
            String name;
            name = this.getChildrenColumnName(fdo);
            fields.add(this.pair(name, name));
        }
        return fields;
    }

    protected FreezeDryedObject parseRow(Class clazz, X row) throws FreezeDryingException {
        try {
            List<String> fields = this.getFields(this.getType(clazz));
            String id = null;
            FreezeDryedObject fdo = new FreezeDryedObject(clazz);
            HashMap<String, String> childsToRead = new HashMap<String, String>();
            int i = 0;
            while (i < fields.size()) {
                block22: {
                    String trueFieldName;
                    Object val;
                    String field = fields.get(i);
                    try {
                        val = this.getFieldValue(row, field);
                    }
                    catch (RuntimeException ex) {
                        if (this.isChildrenField(field)) {
                            LOG.info((Object)("Caught an exception when trying to read children '" + field + "'."), new Object[]{ex});
                            break block22;
                        }
                        throw ex;
                    }
                    if (field.equals(ID_COL) || field.regionMatches(false, 0, ID_COL, 1, ID_COL.length() - 2)) {
                        fdo.setId((String)val);
                        id = (String)val;
                    } else if (field.startsWith(SPECIAL_COL_MARKER) && field.matches("ARRAY.*\\Z")) {
                        trueFieldName = this.getTrueFieldName(field, ARRAY_MARKER);
                        String arrayType = this.getArrayType(field);
                        Object array = this.getArrayValue(arrayType, val);
                        fdo.put(trueFieldName, array);
                    } else {
                        if (field.endsWith(CLASS_MARKER) || field.endsWith("_CLASS\"")) {
                            trueFieldName = this.getTrueFieldName(field, CLASS_MARKER);
                            childsToRead.put(trueFieldName, (String)val);
                        } else if (field.endsWith(CHILD_ID_MARKER) || field.endsWith("_ID\"")) {
                            trueFieldName = this.getTrueFieldName(field, CHILD_ID_MARKER);
                            String childId = (String)val;
                            String className = (String)childsToRead.get(trueFieldName);
                            if (className != null) {
                                FreezeDryedParentChild fdpc = this.readFreezeDryedParentChild(fdo, className, childId);
                                fdo.put(trueFieldName, fdpc);
                                childsToRead.remove(trueFieldName);
                            } else {
                                LOG.warn((Object)("Found a child id '" + childId + "'before finding its corresponding class name. The class name must be returned before the id."), new Object[0]);
                            }
                        } else if (this.isChildrenField(field)) {
                            this.readChildren(fdo);
                        } else if (field.endsWith(BYTES_MARKER) || field.endsWith("_BYTESSTORAGE\"")) {
                            byte[] array = this.readByteArray(fdo, field, val);
                            fdo.put(field.substring(1, field.indexOf(BYTES_MARKER)), array);
                        }
                        fdo.put(field, val);
                    }
                }
                ++i;
            }
            if (id == null) {
                fdo.setId(UUID.randomUUID().toString());
            }
            if (childsToRead.size() > 0) {
                StringBuilder childrenUnread = new StringBuilder();
                for (String string : childsToRead.keySet()) {
                    childrenUnread.append(string).append(",");
                }
                LOG.warn((Object)("Not all (child, childId) pairs were found.  For these classes ids weren't found:\n\t" + childrenUnread.toString()), new Object[0]);
            }
            return fdo;
        }
        catch (ClassNotFoundException ex) {
            throw new FreezeDryingException(ex);
        }
    }

    protected Object getArrayValue(String arrayType, Object val) {
        return ArrayValueHandler.readArray(arrayType, (String)val, ',');
    }

    protected String getArrayType(String field) {
        return field.substring(field.indexOf(ARRAY_MARKER), field.length());
    }

    protected String getTrueFieldName(String field, String marker) {
        int offset = 0;
        if (field.startsWith("\"")) {
            ++offset;
        }
        if (field.startsWith(SPECIAL_COL_MARKER)) {
            offset += SPECIAL_COL_MARKER.length();
        }
        return field.substring(offset, field.indexOf(marker));
    }

    private boolean isChildrenField(String field) {
        return field.endsWith(CHILDREN_MARKER) || field.endsWith("_CHILDREN\"");
    }

    protected FreezeDryedParentChild readFreezeDryedParentChild(FreezeDryedObject parent, String className, String childId) throws ClassNotFoundException {
        FreezeDryedParentChild child = new FreezeDryedParentChild(parent.getType(), parent.getId());
        Class childClass = FieldUtilities.INSTANCE.getClassFromString(className);
        child.setChildClass(childClass);
        child.setChildId(childId);
        return child;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readChildren(FreezeDryedObject fdo) throws ClassNotFoundException, FreezeDryingException {
        this.startChildrenRead(fdo);
        try {
            block7: {
                X x;
                X childsRow;
                block6: {
                    childsRow = null;
                    if (!true) break block6;
                    x = this.readChildsRow(fdo, fdo.getId());
                    childsRow = x;
                    if (x == null) break block7;
                }
                do {
                    FreezeDryedParentChild fdpc;
                    if ((fdpc = this.parseChildRow(fdo, childsRow)) != null) {
                        fdo.addChild(fdpc);
                    }
                    x = this.readChildsRow(fdo, fdo.getId());
                    childsRow = x;
                } while (x != null);
            }
            return;
        }
        finally {
            this.finishChildrenRead(fdo);
        }
    }

    protected FreezeDryedParentChild parseChildRow(FreezeDryedObject fdo, X childsRow) throws ClassNotFoundException, FreezeDryingException {
        FreezeDryedParentChild fdpc = new FreezeDryedParentChild(fdo.getType(), fdo.getId());
        String parentId = this.getFieldValue(childsRow, PARENT_ID_COL).toString();
        if (!parentId.equals(fdo.getId())) {
            return null;
        }
        Class<?> childClass = Class.forName(this.getFieldValue(childsRow, CHILD_CLASS_COL).toString());
        String childId = this.getFieldValue(childsRow, CHILD_ID_COL).toString();
        fdpc.setChildClass(childClass);
        fdpc.setChildId(childId);
        return fdpc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FreezeDryedObject read(Class clazz, String key) throws FreezeDryingException {
        try {
            FreezeDryedObject fdo;
            this.startTypeRead(clazz);
            X row = null;
            do {
                X x = this.readRow(clazz, key);
                row = x;
                if (x != null) continue;
                return null;
            } while (!(fdo = this.parseRow(clazz, row)).getId().equals(key));
            FreezeDryedObject freezeDryedObject = fdo;
            return freezeDryedObject;
        }
        catch (Exception e) {
            throw new FreezeDryingException(e);
        }
        finally {
            this.endTypeRead(clazz);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<FreezeDryedObject> read(Class clazz) throws FreezeDryingException {
        ArrayList<FreezeDryedObject> out = new ArrayList<FreezeDryedObject>();
        try {
            this.startTypeRead(clazz);
            X row = null;
            while (true) {
                X x = this.readRow(clazz, null);
                row = x;
                if (x == null) {
                    ArrayList<FreezeDryedObject> arrayList = out;
                    return arrayList;
                }
                FreezeDryedObject fdo = this.parseRow(clazz, row);
                out.add(fdo);
            }
        }
        catch (Exception e) {
            throw new FreezeDryingException(e);
        }
        finally {
            this.endTypeRead(clazz);
        }
    }

    protected String getChildrenColumnName(FreezeDryedObject fdo) {
        return SPECIAL_COL_MARKER + this.getType(fdo) + CHILDREN_MARKER;
    }
}

