/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.filter;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import repast.simphony.filter.Filter;

public class FilteredIterator<T>
implements Iterator<T> {
    Iterator<T> iterator;
    Filter<T> filter;
    T current;

    public FilteredIterator(Filter<T> filter, Collection<T> collection) {
        this.filter = filter;
        this.iterator = collection.iterator();
    }

    public FilteredIterator(Filter<T> filter, Iterator<T> iterator) {
        this.filter = filter;
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.iterator.hasNext()) {
            T tmp = this.iterator.next();
            if (this.filter.evaluate(tmp)) {
                this.current = tmp;
                return true;
            }
            return this.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T tmp = this.current;
            this.current = null;
            return tmp;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

