/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.watcher.Notifier2;
import repast.simphony.engine.watcher.NotifierID;
import repast.simphony.engine.watcher.WatchParameters;
import repast.simphony.engine.watcher.WatcheeInstrumentor;
import simphony.util.messages.MessageCenter;

public class WatcherTrigger {
    private static MessageCenter msg = MessageCenter.getMessageCenter(WatcherTrigger.class);
    private static WatcherTrigger instance;
    private Map<String, Map<NotifierID, Notifier2>> notifierMap = new HashMap<String, Map<NotifierID, Notifier2>>();
    private Map<Object, List<Notifier2>> objNotifierMap = new HashMap<Object, List<Notifier2>>();
    private WatcheeInstrumentor instrumentor;

    public static WatcherTrigger getInstance() {
        return instance;
    }

    public static void initInstance(WatcheeInstrumentor instrumentor) {
        instance = new WatcherTrigger(instrumentor);
    }

    private WatcherTrigger(WatcheeInstrumentor instrumentor) {
        this.instrumentor = instrumentor;
    }

    public void addFieldSetWatch(WatchParameters params, ISchedule schedule) {
        NotifierID watchID;
        Notifier2 notifier;
        String id = params.createWatcheeID();
        if (!this.instrumentor.isInstrumented(params.getClassName())) {
            msg.warn((Object)("Class '" + params.getClassName() + "' has not been prepared for watching"), (Throwable)new RuntimeException(), new Object[0]);
            return;
        }
        Map<NotifierID, Notifier2> map = this.notifierMap.get(id);
        if (map == null) {
            map = new HashMap<NotifierID, Notifier2>();
            this.notifierMap.put(id, map);
        }
        if ((notifier = map.get(watchID = new NotifierID(params))) == null) {
            notifier = new Notifier2(watchID, params, schedule);
            map.put(watchID, notifier);
        } else {
            notifier.addWatcher(params.getWatcher());
        }
        Object watcher = params.getWatcher();
        List<Notifier2> notList = this.objNotifierMap.get(watcher);
        if (notList == null) {
            notList = new ArrayList<Notifier2>();
            this.objNotifierMap.put(watcher, notList);
        }
        notList.add(notifier);
    }

    public void removeNotifier(Object watcher) {
        List<Notifier2> notifiers = this.objNotifierMap.remove(watcher);
        if (notifiers != null) {
            for (Notifier2 notifier : notifiers) {
                notifier.removeWatcher(watcher);
            }
        }
    }

    private void notify(String id, Object watchee, Object val) {
        Map<NotifierID, Notifier2> notifiers;
        if (this.notifierMap.size() > 0 && (notifiers = this.notifierMap.get(id)) != null) {
            for (Notifier2 notifier : notifiers.values()) {
                notifier.triggered(watchee, val);
            }
        }
    }

    public void triggered(String id, Object watchee, Object val) {
        this.notify(id, watchee, val);
    }

    public void triggered(String id, Object watchee, double val) {
        this.notify(id, watchee, val);
    }

    public void triggered(String id, Object watchee, int val) {
        this.notify(id, watchee, val);
    }

    public void triggered(String id, Object watchee, float val) {
        this.notify(id, watchee, Float.valueOf(val));
    }

    public void triggered(String id, Object watchee, long val) {
        this.notify(id, watchee, val);
    }

    public void triggered(String id, Object watchee, boolean val) {
        this.notify(id, watchee, val);
    }

    public void clearNotifiers() {
        this.notifierMap.clear();
        this.objNotifierMap.clear();
    }
}

