/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.graph.NetworkFactoryFinder;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.Schedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.watcher.Generator;
import repast.simphony.engine.watcher.MyWatcher;
import repast.simphony.engine.watcher.NotifierID;
import repast.simphony.engine.watcher.WatchAnnotationReader;
import repast.simphony.engine.watcher.WatchParameters;
import repast.simphony.engine.watcher.Watcher2;
import repast.simphony.engine.watcher.WatcherTrigger;
import repast.simphony.engine.watcher.WatcherTriggerSchedule;
import repast.simphony.space.graph.Network;

public class WatcherTest
extends TestCase {
    private Schedule schedule;
    private Class clazz;

    public WatcherTest() {
    }

    public WatcherTest(String s) {
        super(s);
    }

    public void setUp() {
        RunState.init();
        WatcherTrigger.getInstance().clearNotifiers();
        this.schedule = new Schedule();
        this.clazz = MyWatcher.class;
    }

    public void testNotifyID() {
        MyWatcher watcher = new MyWatcher();
        try {
            WatchParameters blueParams = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
            blueParams.setWatchID("blue");
            WatchParameters blueParams2 = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
            blueParams2.setWatchID("blue");
            WatchParameters redParams = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
            redParams.setWatchID("red");
            NotifierID blueId = new NotifierID(blueParams);
            NotifierID blue2Id = new NotifierID(blueParams2);
            NotifierID redId = new NotifierID(redParams);
            WatcherTest.assertEquals((Object)blueId, (Object)blue2Id);
            WatcherTest.assertTrue((!blueId.equals(redId) ? 1 : 0) != 0);
            HashMap<NotifierID, String> map = new HashMap<NotifierID, String>();
            map.put(blueId, "A");
            WatcherTest.assertFalse((boolean)map.containsKey(redId));
            WatcherTest.assertNotNull(map.get(blue2Id));
            WatcherTest.assertEquals((String)"A", (String)((String)map.get(blue2Id)));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testBaseCase() {
        MyWatcher watcher = new MyWatcher();
        Generator generator = new Generator();
        Class<?> clazz = watcher.getClass();
        try {
            WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher, clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
            WatcherTrigger.getInstance().addFieldSetWatch(params, null);
            params = new WatchParameters(Generator.class.getName(), "dVal", watcher, clazz.getMethod("watchTrigger", Generator.class, Double.TYPE));
            WatcherTrigger.getInstance().addFieldSetWatch(params, null);
            params = new WatchParameters(Generator.class.getName(), "lVal", watcher, clazz.getMethod("watchTrigger", Generator.class, Long.TYPE));
            WatcherTrigger.getInstance().addFieldSetWatch(params, null);
            params = new WatchParameters(Generator.class.getName(), "bVal", watcher, clazz.getMethod("watchTrigger", Generator.class, Boolean.TYPE));
            WatcherTrigger.getInstance().addFieldSetWatch(params, null);
            params = new WatchParameters(Generator.class.getName(), "fVal", watcher, clazz.getMethod("watchTrigger", Generator.class, Float.TYPE));
            WatcherTrigger.getInstance().addFieldSetWatch(params, null);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        generator.run();
        WatcherTest.assertEquals((Object)watcher.generator, (Object)generator);
        WatcherTest.assertEquals((int)watcher.val, (int)generator.getCounter());
        WatcherTest.assertEquals((Object)watcher.dval, (Object)generator.getdVal());
        WatcherTest.assertEquals((long)watcher.lval, (long)generator.getlVal());
        WatcherTest.assertEquals((Object)Float.valueOf(watcher.fval), (Object)Float.valueOf(generator.getfVal()));
        WatcherTest.assertEquals((char)watcher.cval, (char)generator.getcVal());
        WatcherTest.assertEquals((boolean)watcher.bval, (boolean)generator.isbVal());
    }

    public void testWatcheeCondition() {
        MyWatcher watcher = new MyWatcher();
        Generator generator = new Generator();
        Class<?> clazz = watcher.getClass();
        try {
            WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher, clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
            params.setWatcheeCondition("$field > 10");
            WatcherTrigger.getInstance().addFieldSetWatch(params, this.schedule);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        generator.run();
        WatcherTest.assertEquals((Object)watcher.generator, null);
        WatcherTest.assertEquals((int)watcher.val, (int)-1);
        generator.setCounter(12);
        WatcherTest.assertEquals((Object)watcher.generator, (Object)generator);
        WatcherTest.assertEquals((int)watcher.val, (int)generator.getCounter());
    }

    public void testWatcheeConditionII() {
        MyWatcher watcher = new MyWatcher();
        Generator generator = new Generator();
        WatchParameters params = null;
        try {
            params = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        params.setWatcheeCondition("$watchee.getCounter() > 10 && $watcher.getName().equals(\"Fred\") && $field > 10");
        WatcherTrigger.getInstance().addFieldSetWatch(params, null);
        generator.run();
        WatcherTest.assertEquals((Object)watcher.generator, null);
        WatcherTest.assertEquals((int)watcher.val, (int)-1);
        generator.setCounter(12);
        WatcherTest.assertEquals((Object)watcher.generator, (Object)generator);
        WatcherTest.assertEquals((int)watcher.val, (int)generator.getCounter());
    }

    public void testBaseCaseII() throws NoSuchMethodException {
        MyWatcher watcher = new MyWatcher();
        Generator generator = new Generator();
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        WatcherTrigger.getInstance().addFieldSetWatch(params, null);
        generator.setCounter(15);
        WatcherTest.assertEquals((Object)watcher.generator, (Object)generator);
        WatcherTest.assertEquals((int)watcher.val, (int)generator.getCounter());
    }

    public void testMultWatchers() throws NoSuchMethodException {
        MyWatcher watcher1 = new MyWatcher();
        MyWatcher watcher2 = new MyWatcher();
        Generator generator = new Generator();
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher1, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        WatcherTrigger.getInstance().addFieldSetWatch(params, null);
        params = new WatchParameters(Generator.class.getName(), "counter", watcher2, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        WatcherTrigger.getInstance().addFieldSetWatch(params, null);
        generator.setCounter(15);
        WatcherTest.assertEquals((Object)watcher1.generator, (Object)generator);
        WatcherTest.assertEquals((int)watcher1.val, (int)generator.getCounter());
        WatcherTest.assertEquals((Object)watcher2.generator, (Object)generator);
        WatcherTest.assertEquals((int)watcher2.val, (int)generator.getCounter());
    }

    public void testNotifierNoWatchee() throws NoSuchMethodException {
        MyWatcher watcher = new MyWatcher();
        Generator generator = new Generator();
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Integer.TYPE));
        WatcherTrigger.getInstance().addFieldSetWatch(params, null);
        generator.run();
        WatcherTest.assertTrue((watcher.generator == null ? 1 : 0) != 0);
        WatcherTest.assertEquals((int)watcher.val, (int)generator.getCounter());
    }

    public void testNotifierNoValue() throws NoSuchMethodException {
        MyWatcher watcher = new MyWatcher();
        Generator generator = new Generator();
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class));
        WatcherTrigger.getInstance().addFieldSetWatch(params, null);
        generator.run();
        WatcherTest.assertEquals((Object)watcher.generator, (Object)generator);
        WatcherTest.assertEquals((int)watcher.val, (int)-1);
    }

    public void testScheduleI() throws NoSuchMethodException {
        MyWatcher watcher = new MyWatcher();
        final Generator generator = new Generator();
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        params.setTriggerSchedule(WatcherTriggerSchedule.LATER, 0.0, 0.0);
        WatcherTrigger.getInstance().addFieldSetWatch(params, this.schedule);
        IAction action = new IAction(){

            @Override
            public void execute() {
                generator.run();
            }
        };
        this.schedule.schedule(ScheduleParameters.createOneTime(0.0), action);
        this.schedule.execute();
        WatcherTest.assertEquals((Object)0.0, (Object)this.schedule.getTickCount());
        WatcherTest.assertEquals((int)watcher.val, (int)1);
        WatcherTest.assertEquals((int)generator.getCounter(), (int)1);
    }

    public void testScheduleII() throws NoSuchMethodException {
        MyWatcher watcher = new MyWatcher();
        final Generator generator = new Generator();
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        params.setTriggerSchedule(WatcherTriggerSchedule.LATER, 2.0, 0.0);
        WatcherTrigger.getInstance().addFieldSetWatch(params, this.schedule);
        IAction action = new IAction(){

            @Override
            public void execute() {
                generator.run();
            }
        };
        this.schedule.schedule(ScheduleParameters.createOneTime(1.0), action);
        this.schedule.execute();
        WatcherTest.assertEquals((Object)1.0, (Object)this.schedule.getTickCount());
        WatcherTest.assertEquals((int)watcher.val, (int)-1);
        WatcherTest.assertEquals((int)generator.getCounter(), (int)1);
        this.schedule.execute();
        WatcherTest.assertEquals((Object)3.0, (Object)this.schedule.getTickCount());
        WatcherTest.assertEquals((int)watcher.val, (int)1);
        WatcherTest.assertEquals((int)generator.getCounter(), (int)1);
    }

    public void testScheduleIII() throws NoSuchMethodException {
        final Generator generator = new Generator();
        MyWatcher watcher3 = new MyWatcher();
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", watcher3, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        params.setTriggerSchedule(WatcherTriggerSchedule.LATER, 2.0, 3.0);
        WatcherTrigger.getInstance().addFieldSetWatch(params, this.schedule);
        MyWatcher watcher1 = new MyWatcher();
        params = new WatchParameters(Generator.class.getName(), "counter", watcher1, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        params.setTriggerSchedule(WatcherTriggerSchedule.LATER, 2.0, 1.0);
        WatcherTrigger.getInstance().addFieldSetWatch(params, this.schedule);
        MyWatcher watcher2 = new MyWatcher();
        params = new WatchParameters(Generator.class.getName(), "counter", watcher2, this.clazz.getMethod("watchTrigger", Generator.class, Integer.TYPE));
        params.setTriggerSchedule(WatcherTriggerSchedule.LATER, 2.0, 2.0);
        WatcherTrigger.getInstance().addFieldSetWatch(params, this.schedule);
        IAction action = new IAction(){

            @Override
            public void execute() {
                generator.run();
            }
        };
        this.schedule.schedule(ScheduleParameters.createOneTime(0.0), action);
        this.schedule.execute();
        WatcherTest.assertEquals((Object)0.0, (Object)this.schedule.getTickCount());
        WatcherTest.assertEquals((int)watcher3.val, (int)-1);
        WatcherTest.assertEquals((int)watcher1.val, (int)-1);
        WatcherTest.assertEquals((int)watcher2.val, (int)-1);
        WatcherTest.assertEquals((int)generator.getCounter(), (int)1);
        this.schedule.execute();
        WatcherTest.assertEquals((Object)2.0, (Object)this.schedule.getTickCount());
        WatcherTest.assertEquals((int)watcher3.val, (int)1);
        WatcherTest.assertEquals((int)watcher1.val, (int)1);
        WatcherTest.assertEquals((int)watcher2.val, (int)1);
        WatcherTest.assertEquals((int)generator.getCounter(), (int)1);
    }

    public void testDblFieldAnnotation() {
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(MyWatcher.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DefaultContext context = new DefaultContext();
        context.addContextListener(reader.getContextListener(this.schedule));
        MyWatcher watcher = new MyWatcher();
        context.add(watcher);
        Generator generator = new Generator();
        generator.setBVal();
        WatcherTest.assertTrue((boolean)watcher.queryResult("double_field"));
        watcher.queryResult.clear();
        generator.incrCounter();
        WatcherTest.assertTrue((boolean)watcher.queryResult("double_field"));
    }

    public void testAnnotation() {
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(MyWatcher.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DefaultContext context = new DefaultContext();
        context.addContextListener(reader.getContextListener(this.schedule));
        MyWatcher watcher = new MyWatcher();
        context.add(watcher);
        WatcherTest.assertEquals((int)watcher.plainTriggerVal, (int)-1);
        WatcherTest.assertEquals((int)watcher.valTriggerVal, (int)-1);
        WatcherTest.assertEquals((int)watcher.genTriggerVal, (int)-1);
        WatcherTest.assertEquals((int)watcher.genValTriggerVal, (int)-1);
        Generator generator = new Generator();
        generator.run();
        WatcherTest.assertEquals((int)watcher.plainTriggerVal, (int)0);
        WatcherTest.assertEquals((int)watcher.valTriggerVal, (int)generator.getCounter());
        WatcherTest.assertEquals((int)watcher.genTriggerVal, (int)0);
        WatcherTest.assertEquals((int)watcher.genValTriggerVal, (int)generator.getCounter());
        WatcherTest.assertEquals((Object)watcher.generator, (Object)generator);
    }

    public void testAnnotationCondition() {
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(MyWatcher.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DefaultContext context = new DefaultContext();
        context.addContextListener(reader.getContextListener(this.schedule));
        MyWatcher watcher = new MyWatcher();
        context.add(watcher);
        WatcherTest.assertEquals((boolean)watcher.triggered, (boolean)false);
        Generator generator = new Generator();
        generator.run();
        WatcherTest.assertEquals((boolean)watcher.triggered, (boolean)false);
        generator.run();
        WatcherTest.assertEquals((boolean)watcher.triggered, (boolean)true);
    }

    public void testAnnotationSchedule() {
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(MyWatcher.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DefaultContext context = new DefaultContext();
        context.addContextListener(reader.getContextListener(this.schedule));
        MyWatcher watcher = new MyWatcher();
        context.add(watcher);
        final Generator generator = new Generator();
        IAction action = new IAction(){

            @Override
            public void execute() {
                generator.run();
            }
        };
        this.schedule.schedule(ScheduleParameters.createOneTime(0.0), action);
        this.schedule.execute();
        WatcherTest.assertEquals((Object)0.0, (Object)this.schedule.getTickCount());
        WatcherTest.assertEquals((boolean)watcher.scheduleTest, (boolean)false);
        this.schedule.execute();
        WatcherTest.assertEquals((Object)2.0, (Object)this.schedule.getTickCount());
        WatcherTest.assertEquals((boolean)watcher.scheduleTest, (boolean)true);
    }

    public void testAnnotationBadMethod() {
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(MyWatcher.class);
            reader.processClass(Watcher2.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DefaultContext context = new DefaultContext();
        context.addContextListener(reader.getContextListener(this.schedule));
        Watcher2 watcher = new Watcher2();
        try {
            context.add(watcher);
            WatcherTest.assertTrue((boolean)false);
        }
        catch (RuntimeException ex) {
            WatcherTest.assertTrue((boolean)true);
        }
    }

    public void testAnnotationQuery() {
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(MyWatcher.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DefaultContext context = new DefaultContext();
        context.addContextListener(reader.getContextListener(this.schedule));
        MyWatcher watcher = new MyWatcher();
        context.add(watcher);
        final Generator generator = new Generator();
        context.add(generator);
        IAction action = new IAction(){

            @Override
            public void execute() {
                generator.run();
            }
        };
        this.schedule.schedule(ScheduleParameters.createRepeating(1.0, 1.0), action);
        this.schedule.execute();
        WatcherTest.assertEquals((boolean)false, (boolean)watcher.queryResult("linked"));
        Network<Generator> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", context, true);
        net.addEdge((Generator)((Object)watcher), generator);
        this.schedule.execute();
        WatcherTest.assertEquals((boolean)true, (boolean)watcher.queryResult("linked"));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(WatcherTest.class);
        return suite;
    }
}

