/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.lang.reflect.Method;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.graph.NetworkFactoryFinder;
import repast.simphony.context.space.grid.GridFactoryFinder;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.Schedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.watcher.Generator;
import repast.simphony.engine.watcher.MyMultWatcher;
import repast.simphony.engine.watcher.MyWatcher;
import repast.simphony.engine.watcher.WatchAnnotationReader;
import repast.simphony.engine.watcher.WatchData;
import repast.simphony.engine.watcher.WatchParameters;
import repast.simphony.engine.watcher.WatcherTrigger;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridBuilderParameters;
import repast.simphony.space.grid.SimpleGridAdder;

public class WatcherQueryTests
extends TestCase {
    private Schedule schedule;
    private MyWatcher watcher;
    private MyMultWatcher multWatcher;
    private Generator generator;
    Context<Object> context;

    public WatcherQueryTests(String string) {
        super(string);
    }

    public WatcherQueryTests() {
    }

    public void setUp() {
        RunState.init();
        WatcherTrigger.getInstance().clearNotifiers();
        this.schedule = new Schedule();
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(MyWatcher.class);
            reader.processClass(MyMultWatcher.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.context = new DefaultContext<Object>();
        this.context.addContextListener(reader.getContextListener(this.schedule));
        this.watcher = new MyWatcher();
        this.context.add(this.watcher);
        this.multWatcher = new MyMultWatcher();
        this.context.add(this.multWatcher);
        this.generator = new Generator();
        this.context.add(this.generator);
        IAction action = new IAction(){

            @Override
            public void execute() {
                WatcherQueryTests.this.generator.run();
            }
        };
        this.schedule.schedule(ScheduleParameters.createRepeating(1.0, 1.0), action);
    }

    public void testLinkedQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked"));
        Network<Object> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, true);
        RepastEdge<Object> edge = net.addEdge(this.watcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("linked"));
        this.watcher.queryResult.clear();
        net.removeEdge(edge);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked"));
    }

    public void testLinkedMultQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertTrue((!this.multWatcher.isTriggered() ? 1 : 0) != 0);
        WatcherQueryTests.assertEquals((String)"", (String)this.multWatcher.getWatchID());
        Network<Object> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network_1", this.context, true);
        RepastEdge<Object> edge = net.addEdge(this.multWatcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertTrue((boolean)this.multWatcher.isTriggered());
        WatcherQueryTests.assertEquals((String)"watch1", (String)this.multWatcher.getWatchID());
        this.multWatcher.reset();
        net.removeEdge(edge);
        this.schedule.execute();
        WatcherQueryTests.assertTrue((!this.multWatcher.isTriggered() ? 1 : 0) != 0);
        WatcherQueryTests.assertEquals((String)"", (String)this.multWatcher.getWatchID());
        net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network_2", this.context, true);
        edge = net.addEdge(this.multWatcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertTrue((boolean)this.multWatcher.isTriggered());
        WatcherQueryTests.assertEquals((String)"watch2", (String)this.multWatcher.getWatchID());
        this.multWatcher.reset();
        net.removeEdge(edge);
        this.schedule.execute();
        WatcherQueryTests.assertTrue((!this.multWatcher.isTriggered() ? 1 : 0) != 0);
        WatcherQueryTests.assertEquals((String)"", (String)this.multWatcher.getWatchID());
    }

    public void testMultNoAnnotation() throws NoSuchMethodException {
        Class<?> clazz = this.multWatcher.getClass();
        Method method = clazz.getMethod("nonAnnotatedTrigger", WatchData.class, Generator.class, Integer.TYPE);
        WatchParameters params = new WatchParameters(Generator.class.getName(), "counter", this.multWatcher, method);
        String watchID = "Non Annotated Watch";
        params.setWatchID(watchID);
        WatcherTrigger.getInstance().addFieldSetWatch(params, this.schedule);
        WatcherQueryTests.assertTrue((!this.multWatcher.isTriggered() ? 1 : 0) != 0);
        WatcherQueryTests.assertEquals((String)"", (String)this.multWatcher.getWatchID());
        this.schedule.execute();
        WatcherQueryTests.assertTrue((boolean)this.multWatcher.isTriggered());
        WatcherQueryTests.assertEquals((String)watchID, (String)this.multWatcher.getWatchID());
        WatcherQueryTests.assertEquals((Object)this.generator, (Object)this.multWatcher.generator);
        WatcherQueryTests.assertEquals((int)this.generator.getCounter(), (int)this.multWatcher.val);
    }

    public void testLinkedToQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_to"));
        Network<Object> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, true);
        RepastEdge<Object> edge = net.addEdge(this.watcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("linked_to"));
        this.watcher.queryResult.clear();
        net.removeEdge(edge);
        net.addEdge(this.generator, this.watcher);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_to"));
    }

    public void testLinkedToNamedQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_to_named"));
        Network<Object> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, true);
        net.addEdge(this.watcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_to_named"));
        net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("family", this.context, true);
        this.watcher.queryResult.clear();
        net.addEdge(this.watcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("linked_to_named"));
    }

    public void testLinkedFromQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_from"));
        Network<Object> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, true);
        RepastEdge<Object> edge = net.addEdge(this.watcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_from"));
        this.watcher.queryResult.clear();
        net.addEdge(this.generator, this.watcher);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("linked_from"));
    }

    public void testLinkedNonDirectedQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_from"));
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("linked_to"));
        Network<Object> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, false);
        net.addEdge(this.watcher, this.generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("linked_from"));
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("linked_to"));
    }

    public void testWithinQuery() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int i = 0;
        while (i < 7) {
            ints.add(new Integer(i));
            this.context.add(ints.get(i));
            ++i;
        }
        Network<Object> net1 = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, false);
        net1.addEdge(this.watcher, ints.get(1), 2.0);
        net1.addEdge(this.watcher, ints.get(3), 1.0);
        net1.addEdge(ints.get(1), ints.get(3), 3.0);
        net1.addEdge(ints.get(1), this.generator, 10.0);
        net1.addEdge(ints.get(2), this.watcher, 4.0);
        net1.addEdge(ints.get(2), ints.get(5), 5.0);
        net1.addEdge(ints.get(3), ints.get(2), 2.0);
        RepastEdge<Object> edge = net1.addEdge(ints.get(3), this.generator, 2.0);
        net1.addEdge(ints.get(3), ints.get(5), 8.0);
        net1.addEdge(ints.get(3), ints.get(6), 4.0);
        net1.addEdge(this.generator, ints.get(6), 6.0);
        net1.addEdge(ints.get(6), ints.get(5), 1.0);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within"));
        net1.removeEdge(edge);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within"));
    }

    public void testWithinNghQuery() {
        GridBuilderParameters params = GridBuilderParameters.singleOccupancy2DTorus(new SimpleGridAdder(), 10, 30);
        Grid<Object> grid = GridFactoryFinder.createGridFactory(null).createGrid("2D Torus", this.context, params);
        grid.moveTo(this.watcher, 3, 3);
        grid.moveTo(this.generator, 3, 4);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within_vn"));
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within_moore"));
        grid.moveTo(this.watcher, 9, 29);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_vn"));
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_moore"));
        grid.moveTo(this.watcher, 3, 3);
        grid.moveTo(this.generator, 1, 1);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_vn"));
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within_moore"));
    }

    public void testWithinNamedNghQuery() {
        GridBuilderParameters params = GridBuilderParameters.singleOccupancy2DTorus(new SimpleGridAdder(), 10, 30);
        Grid<Object> grid = GridFactoryFinder.createGridFactory(null).createGrid("2D Torus", this.context, params);
        grid.moveTo(this.watcher, 3, 3);
        grid.moveTo(this.generator, 3, 4);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_vn_named"));
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_moore_named"));
        grid = GridFactoryFinder.createGridFactory(null).createGrid("family", this.context, params);
        grid.moveTo(this.watcher, 3, 3);
        grid.moveTo(this.generator, 3, 4);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within_vn_named"));
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within_moore_named"));
        grid.moveTo(this.watcher, 9, 29);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_vn_named"));
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_moore_named"));
        grid.moveTo(this.watcher, 3, 3);
        grid.moveTo(this.generator, 1, 1);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_vn_named"));
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within_moore_named"));
    }

    public void testWithinNamedQuery() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int i = 0;
        while (i < 7) {
            ints.add(new Integer(i));
            this.context.add(ints.get(i));
            ++i;
        }
        Network<Object> net1 = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, false);
        net1.addEdge(this.watcher, ints.get(1), 2.0);
        net1.addEdge(this.watcher, ints.get(3), 1.0);
        net1.addEdge(ints.get(1), ints.get(3), 3.0);
        net1.addEdge(ints.get(1), this.generator, 10.0);
        net1.addEdge(ints.get(2), this.watcher, 4.0);
        net1.addEdge(ints.get(2), ints.get(5), 5.0);
        net1.addEdge(ints.get(3), ints.get(2), 2.0);
        RepastEdge<Object> edge = net1.addEdge(ints.get(3), this.generator, 2.0);
        net1.addEdge(ints.get(3), ints.get(5), 8.0);
        net1.addEdge(ints.get(3), ints.get(6), 4.0);
        net1.addEdge(this.generator, ints.get(6), 6.0);
        net1.addEdge(ints.get(6), ints.get(5), 1.0);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_named"));
        net1 = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("family", this.context, true);
        net1.addEdge(this.watcher, ints.get(1), 2.0);
        net1.addEdge(this.watcher, ints.get(3), 1.0);
        net1.addEdge(ints.get(1), ints.get(3), 3.0);
        net1.addEdge(ints.get(1), this.generator, 10.0);
        net1.addEdge(ints.get(2), this.watcher, 4.0);
        net1.addEdge(ints.get(2), ints.get(5), 5.0);
        net1.addEdge(ints.get(3), ints.get(2), 2.0);
        edge = net1.addEdge(ints.get(3), this.generator, 2.0);
        net1.addEdge(ints.get(3), ints.get(5), 8.0);
        net1.addEdge(ints.get(3), ints.get(6), 4.0);
        net1.addEdge(this.generator, ints.get(6), 6.0);
        net1.addEdge(ints.get(6), ints.get(5), 1.0);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("within_named"));
        net1.removeEdge(edge);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("within_named"));
    }

    public void testColocatedQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("colocated"));
        this.context.remove(this.generator);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("colocated"));
    }

    public void testNotColocatedQuery() {
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)this.watcher.queryResult("not_colocated"));
        this.context.remove(this.generator);
        this.watcher.queryResult.clear();
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)true, (boolean)this.watcher.queryResult("not_colocated"));
    }

    public void testSubLinkedToNamedQuery() {
        this.context.remove(this.watcher);
        this.context.remove(this.generator);
        DefaultContext sub = new DefaultContext();
        MyWatcher watcher = new MyWatcher();
        final Generator generator = new Generator();
        sub.add(watcher);
        sub.add(generator);
        this.context.addSubContext(sub);
        IAction action = new IAction(){

            @Override
            public void execute() {
                generator.run();
            }
        };
        this.schedule = new Schedule();
        this.schedule.schedule(ScheduleParameters.createRepeating(1.0, 1.0), action);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)watcher.queryResult("linked_to_named"));
        Network<Object> net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("family", this.context, true);
        net.addEdge(watcher, generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)watcher.queryResult("linked_to_named"));
        net = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("family", sub, true);
        watcher.queryResult.clear();
        net.addEdge(watcher, generator);
        this.schedule.execute();
        WatcherQueryTests.assertEquals((boolean)false, (boolean)watcher.queryResult("linked_to_named"));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(WatcherQueryTests.class);
        return suite;
    }
}

