/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.Schedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.watcher.Counter;
import repast.simphony.engine.watcher.Generator;
import repast.simphony.engine.watcher.PickTestAgent;
import repast.simphony.engine.watcher.WatchAnnotationReader;
import repast.simphony.engine.watcher.WatcherTrigger;

public class WatcherPickTests
extends TestCase {
    private Schedule schedule;
    private Generator generator;
    Context<Object> context;

    public WatcherPickTests(String string) {
        super(string);
    }

    public WatcherPickTests() {
    }

    public void setUp() {
        RunState.init();
        WatcherTrigger.getInstance().clearNotifiers();
        this.schedule = new Schedule();
        WatchAnnotationReader reader = new WatchAnnotationReader();
        try {
            reader.processClass(PickTestAgent.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.context = new DefaultContext<Object>();
        this.context.addContextListener(reader.getContextListener(this.schedule));
        this.generator = new Generator();
        this.context.add(this.generator);
        IAction action = new IAction(){

            @Override
            public void execute() {
                WatcherPickTests.this.generator.run();
            }
        };
        this.schedule.schedule(ScheduleParameters.createRepeating(1.0, 1.0), action);
    }

    public void testLessThanPick() {
        Counter counter = new Counter();
        int i = 0;
        while (i < 8) {
            this.context.add(new PickTestAgent(counter));
            ++i;
        }
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)8, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)0, (int)counter.getCountB());
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)16, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)8, (int)counter.getCountB());
    }

    public void testGreaterThanPick() {
        Counter counter = new Counter();
        int i = 0;
        while (i < 40) {
            this.context.add(new PickTestAgent(counter));
            ++i;
        }
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)10, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)0, (int)counter.getCountB());
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)20, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)10, (int)counter.getCountB());
    }

    public void testEqualsPick() {
        Counter counter = new Counter();
        int i = 0;
        while (i < 10) {
            this.context.add(new PickTestAgent(counter));
            ++i;
        }
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)10, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)0, (int)counter.getCountB());
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)20, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)10, (int)counter.getCountB());
    }

    public void testRemoveWithPick() {
        Counter counter = new Counter();
        ArrayList<PickTestAgent> agents = new ArrayList<PickTestAgent>();
        int i = 0;
        while (i < 12) {
            PickTestAgent agent = new PickTestAgent(counter);
            this.context.add(agent);
            agents.add(agent);
            ++i;
        }
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)10, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)0, (int)counter.getCountB());
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)20, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)10, (int)counter.getCountB());
        this.context.remove(agents.get(0));
        this.context.remove(agents.get(1));
        this.context.remove(agents.get(2));
        this.schedule.execute();
        this.schedule.execute();
        WatcherPickTests.assertEquals((int)38, (int)counter.getCountA());
        WatcherPickTests.assertEquals((int)29, (int)counter.getCountB());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(WatcherPickTests.class);
        return suite;
    }
}

