/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.graph.NetworkBuilder;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.CallBackAction;
import repast.simphony.engine.schedule.Schedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.watcher.WatchAnnotationReader;
import repast.simphony.engine.watcher.WatcherTrigger;
import repast.simphony.space.graph.Network;
import watcherOOP.test.OOPWatcherOnA;
import watcherOOP.test.OOPWatcherOnB;
import watcherOOP.test.OOPWatcherOnC;
import watcherOOP.test.SimpleWatchee;
import watcherOOP.test.SimpleWatcher;
import watcherOOP.test.WatcheeChildA;
import watcherOOP.test.WatcheeChildB;
import watcherOOP.test.WatcheeChildC;
import watcherOOP.test.WatcherWithQuery;

public class WatcherOOPTests {
    public void setUp() {
        RunState.init();
        WatcherTrigger.getInstance().clearNotifiers();
    }

    private Context<Object> setupContext(Schedule schedule, Object ... watchers) {
        int n;
        WatchAnnotationReader reader = new WatchAnnotationReader();
        HashSet classes = new HashSet();
        try {
            Object[] objectArray = watchers;
            n = watchers.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                classes.add(obj.getClass());
                ++n2;
            }
            reader.processClasses(new ArrayList(classes));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DefaultContext<Object> context = new DefaultContext<Object>();
        context.addContextListener(reader.getContextListener(schedule));
        Object[] objectArray = watchers;
        int n3 = watchers.length;
        n = 0;
        while (n < n3) {
            Object obj = objectArray[n];
            context.add(obj);
            ++n;
        }
        return context;
    }

    @Test
    public void baseTest() {
        System.out.println("Base Test");
        Schedule schedule = new Schedule();
        SimpleWatcher watcher = new SimpleWatcher();
        this.setupContext(schedule, watcher);
        int newIntVal = 2;
        SimpleWatchee watchee = new SimpleWatchee();
        CallBackAction action1 = new CallBackAction((Object)watchee, "updateInt", newIntVal);
        schedule.schedule(ScheduleParameters.createOneTime(0.0), action1);
        String newStringVal = "fulham";
        CallBackAction action2 = new CallBackAction((Object)watchee, "updateString", newStringVal);
        schedule.schedule(ScheduleParameters.createOneTime(1.0), action2);
        schedule.execute();
        Assert.assertEquals((long)newIntVal, (long)watcher.getInt());
        schedule.execute();
        Assert.assertEquals((Object)newStringVal, (Object)watcher.getStr());
    }

    @Test
    public void testOOPChange() {
        System.out.println("Test OOP Change");
        Schedule schedule = new Schedule();
        OOPWatcherOnC watcherOnC = new OOPWatcherOnC();
        this.setupContext(schedule, watcherOnC);
        SimpleWatchee simple = new SimpleWatchee();
        String newStringVal = "fulham";
        CallBackAction action = new CallBackAction((Object)simple, "updateString", newStringVal);
        schedule.schedule(ScheduleParameters.createOneTime(0.0), action);
        WatcheeChildC watchee = new WatcheeChildC();
        action = new CallBackAction((Object)watchee, "cIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(1.0), action);
        action = new CallBackAction((Object)watchee, "cIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(2.0), action);
        action = new CallBackAction((Object)watchee, "aIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(3.0), action);
        action = new CallBackAction((Object)watchee, "aIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(4.0), action);
        action = new CallBackAction((Object)watchee, "incrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(5.0), action);
        schedule.execute();
        Assert.assertEquals((Object)newStringVal, (Object)watcherOnC.getString());
        watcherOnC.reset();
        schedule.execute();
        Assert.assertEquals((long)2L, (long)watcherOnC.getVal());
        watcherOnC.reset();
        schedule.execute();
        Assert.assertEquals((long)3L, (long)watcherOnC.getVal());
        watcherOnC.reset();
        schedule.execute();
        Assert.assertEquals((long)4L, (long)watcherOnC.getVal());
        watcherOnC.reset();
        schedule.execute();
        Assert.assertEquals((long)5L, (long)watcherOnC.getVal());
        watcherOnC.reset();
        schedule.execute();
        Assert.assertEquals((long)6L, (long)watcherOnC.getVal());
        watcherOnC.reset();
    }

    @Test
    public void testChildInclusion() {
        System.out.println("Test CI");
        Schedule schedule = new Schedule();
        OOPWatcherOnC watcherOnC = new OOPWatcherOnC();
        OOPWatcherOnA watcherOnA = new OOPWatcherOnA();
        this.setupContext(schedule, watcherOnC, watcherOnA);
        WatcheeChildC watchee = new WatcheeChildC();
        CallBackAction action = new CallBackAction((Object)watchee, "cIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(2.0), action);
        action = new CallBackAction((Object)watchee, "aIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(3.0), action);
        action = new CallBackAction((Object)watchee, "aIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(4.0), action);
        action = new CallBackAction((Object)watchee, "incrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(5.0), action);
        schedule.execute();
        Assert.assertEquals((long)2L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)2L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)3L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)3L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)4L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)4L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)5L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)5L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
    }

    @Test
    public void testChildExclusion() {
        System.out.println("Test CE");
        Schedule schedule = new Schedule();
        OOPWatcherOnC watcherOnC = new OOPWatcherOnC();
        OOPWatcherOnA watcherOnA = new OOPWatcherOnA();
        this.setupContext(schedule, watcherOnC, watcherOnA);
        WatcheeChildA watchee = new WatcheeChildA();
        WatcheeChildC watcheeC = new WatcheeChildC();
        CallBackAction action = new CallBackAction((Object)watchee, "aIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(1.0), action);
        action = new CallBackAction((Object)watchee, "aIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(2.0), action);
        action = new CallBackAction((Object)watchee, "incrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(3.0), action);
        action = new CallBackAction((Object)watcheeC, "incrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(4.0), action);
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)2L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)3L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)4L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)2L, (long)watcherOnC.getVal());
        Assert.assertEquals((long)2L, (long)watcherOnA.getVal());
        watcherOnC.reset();
        watcherOnA.reset();
    }

    @Test
    public void testSiblingExclusion() {
        System.out.println("Test SE");
        Schedule schedule = new Schedule();
        OOPWatcherOnB watcherOnB = new OOPWatcherOnB();
        OOPWatcherOnA watcherOnA = new OOPWatcherOnA();
        this.setupContext(schedule, watcherOnB, watcherOnA);
        WatcheeChildA watcheeA = new WatcheeChildA();
        WatcheeChildB watcheeB = new WatcheeChildB();
        watcherOnB.reset();
        watcherOnA.reset();
        CallBackAction action = new CallBackAction((Object)watcheeA, "aIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(1.0), action);
        action = new CallBackAction((Object)watcheeB, "bIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(2.0), action);
        action = new CallBackAction((Object)watcheeA, "aIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(3.0), action);
        action = new CallBackAction((Object)watcheeB, "bIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(4.0), action);
        schedule.execute();
        Assert.assertEquals((long)2L, (long)watcherOnA.getVal());
        Assert.assertEquals((double)-1.0, (double)watcherOnB.getVal(), (double)0.0);
        watcherOnB.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcherOnA.getVal());
        Assert.assertEquals((double)2.0, (double)watcherOnB.getVal(), (double)0.0);
        watcherOnB.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)3L, (long)watcherOnA.getVal());
        Assert.assertEquals((double)-1.0, (double)watcherOnB.getVal(), (double)0.0);
        watcherOnB.reset();
        watcherOnA.reset();
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcherOnA.getVal());
        Assert.assertEquals((double)3.0, (double)watcherOnB.getVal(), (double)0.0);
        watcherOnB.reset();
        watcherOnA.reset();
    }

    @Test
    public void testCache() {
        OOPWatcherOnA watcher;
        System.out.println("Test Cache");
        Schedule schedule = new Schedule();
        OOPWatcherOnA[] watchers = new OOPWatcherOnA[]{new OOPWatcherOnA(), new OOPWatcherOnA(), new OOPWatcherOnA(), new OOPWatcherOnA()};
        this.setupContext(schedule, watchers[0], watchers[1], watchers[2], watchers[3]);
        WatcheeChildA watchee = new WatcheeChildA();
        CallBackAction action = new CallBackAction((Object)watchee, "aIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(1.0), action);
        action = new CallBackAction((Object)watchee, "aIncrValSuper", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(2.0), action);
        action = new CallBackAction((Object)watchee, "incrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createOneTime(3.0), action);
        schedule.execute();
        OOPWatcherOnA[] oOPWatcherOnAArray = watchers;
        int n = watchers.length;
        int n2 = 0;
        while (n2 < n) {
            watcher = oOPWatcherOnAArray[n2];
            Assert.assertEquals((long)2L, (long)watcher.getVal());
            watcher.reset();
            ++n2;
        }
        schedule.execute();
        oOPWatcherOnAArray = watchers;
        n = watchers.length;
        n2 = 0;
        while (n2 < n) {
            watcher = oOPWatcherOnAArray[n2];
            Assert.assertEquals((long)3L, (long)watcher.getVal());
            watcher.reset();
            ++n2;
        }
        schedule.execute();
        oOPWatcherOnAArray = watchers;
        n = watchers.length;
        n2 = 0;
        while (n2 < n) {
            watcher = oOPWatcherOnAArray[n2];
            Assert.assertEquals((long)4L, (long)watcher.getVal());
            watcher.reset();
            ++n2;
        }
    }

    @Test
    public void testCacheWithQuery() {
        System.out.println("Test Cache With Query");
        WatcherWithQuery watcher1 = new WatcherWithQuery();
        WatcherWithQuery watcher2 = new WatcherWithQuery();
        Schedule schedule = new Schedule();
        Context<Object> context = this.setupContext(schedule, watcher1, watcher2);
        WatcheeChildA watchee = new WatcheeChildA();
        CallBackAction action = new CallBackAction((Object)watchee, "aIncrVal", new Object[0]);
        schedule.schedule(ScheduleParameters.createRepeating(1.0, 1.0), action);
        watcher1.reset();
        watcher2.reset();
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcher1.getVal());
        Assert.assertEquals((long)-1L, (long)watcher2.getVal());
        NetworkBuilder<Object> builder = new NetworkBuilder<Object>("network", context, true);
        Network<Object> net = builder.buildNetwork();
        net.addEdge(watcher1, watchee);
        watcher1.reset();
        watcher2.reset();
        schedule.execute();
        Assert.assertEquals((long)3L, (long)watcher1.getVal());
        Assert.assertEquals((long)-1L, (long)watcher2.getVal());
        net.addEdge(watcher2, watchee);
        watcher1.reset();
        watcher2.reset();
        schedule.execute();
        Assert.assertEquals((long)4L, (long)watcher1.getVal());
        Assert.assertEquals((long)4L, (long)watcher2.getVal());
        net.removeEdge(net.getEdge(watcher1, watchee));
        watcher1.reset();
        watcher2.reset();
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcher1.getVal());
        Assert.assertEquals((long)5L, (long)watcher2.getVal());
        net.removeEdge(net.getEdge(watcher2, watchee));
        watcher1.reset();
        watcher2.reset();
        schedule.execute();
        Assert.assertEquals((long)-1L, (long)watcher1.getVal());
        Assert.assertEquals((long)-1L, (long)watcher2.getVal());
    }
}

