/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;

public class WatcherEditor
extends ExprEditor {
    private String fieldName;
    private boolean addID = true;

    public WatcherEditor(String fieldName) {
        this.fieldName = fieldName;
    }

    private boolean hasField(CtField[] ctFields, String fieldName) {
        CtField[] ctFieldArray = ctFields;
        int n = ctFields.length;
        int n2 = 0;
        while (n2 < n) {
            CtField field = ctFieldArray[n2];
            if (field.getName().equals(fieldName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void edit(FieldAccess arg) throws CannotCompileException {
        if (arg.isWriter() && arg.getFieldName().equals(this.fieldName) && !(arg.where() instanceof CtConstructor)) {
            String idName = "__id__" + arg.getFieldName();
            if (this.addID) {
                try {
                    CtClass ctClass = arg.getField().getDeclaringClass();
                    if (!this.hasField(ctClass.getDeclaredFields(), idName)) {
                        StringBuffer buf = new StringBuffer("protected static String ");
                        buf.append(idName);
                        buf.append(" = \"");
                        buf.append(ctClass.getName());
                        buf.append(".");
                        buf.append(arg.getFieldName());
                        buf.append("\";");
                        CtField field = CtField.make((String)buf.toString(), (CtClass)ctClass);
                        ctClass.addField(field);
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
                this.addID = false;
            }
            StringBuilder code = new StringBuilder();
            code.append("$proceed($$);");
            code.append("repast.simphony.engine.watcher.WatcherTrigger.getInstance().triggered(");
            code.append(idName);
            code.append(", $0, $1);");
            arg.replace(code.toString());
        }
    }
}

