/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.expr.ExprEditor;
import repast.simphony.engine.watcher.WatcheeData;
import repast.simphony.engine.watcher.WatcheeDataFinder;
import repast.simphony.engine.watcher.WatcherEditor;
import repast.simphony.filter.AllFilter;
import repast.simphony.filter.Filter;
import simphony.util.messages.MessageCenter;

public class WatcheeInstrumentor {
    private static MessageCenter msg = MessageCenter.getMessageCenter(WatcheeInstrumentor.class);
    private WatcheeDataFinder watcheeFinder = new WatcheeDataFinder(this);
    private static Set<String> instrumented = new HashSet<String>();

    public void addFieldToWatch(String className, String fieldName) {
        this.watcheeFinder.addClassToFind(className, fieldName);
    }

    public void addFieldToWatchFromWatcherPath(String path) {
        this.watcheeFinder.addPathToSearch(path);
    }

    public void instrument(String classpath) {
        this.instrument(classpath, new AllFilter<String>());
    }

    public void instrument(String classpath, Filter<String> filter) {
        try {
            WatcheeDataFinder.FinderResult result = this.watcheeFinder.run(classpath, filter);
            if (result.failed()) {
                msg.warn((Object)(String.valueOf(result.getMessage()) + " classpath: " + classpath), new Object[0]);
            }
            ClassPool pool = ClassPool.getDefault();
            pool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
            for (WatcheeData data : this.watcheeFinder.data()) {
                if (data.path == null || instrumented.contains(data.className)) continue;
                BufferedInputStream stream = new BufferedInputStream(data.path.openStream());
                CtClass ctClass = pool.makeClass((InputStream)stream);
                stream.close();
                for (String field : data.fields) {
                    ctClass.instrument((ExprEditor)new WatcherEditor(field));
                }
                ctClass.toClass(this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
                instrumented.add(data.className);
            }
        }
        catch (IOException e) {
            msg.error((Object)"Error while instrumenting watchee class", (Throwable)e, new Object[0]);
        }
        catch (CannotCompileException e) {
            msg.error((Object)"Error while instrumenting watchee class", (Throwable)e, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            msg.error((Object)"Error while instrumenting watchee class", (Throwable)e, new Object[0]);
        }
    }

    public boolean isInstrumented(String className) {
        return instrumented.contains(className);
    }

    public static Set<String> getInstrumented() {
        return instrumented;
    }
}

