/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import repast.simphony.engine.watcher.WatcheeData;
import repast.simphony.engine.watcher.WatcheeDataFinder;
import repast.simphony.engine.watcher.WatcheeInstrumentor;
import repast.simphony.util.ClassPathFilter;

public class WatcheeDataFinderTests {
    private File classpath = new File("./test_bin/");
    private WatcheeDataFinder finder;

    static {
        BasicConfigurator.configure();
    }

    @Before
    public void setup() {
        this.finder = new WatcheeDataFinder(new WatcheeInstrumentor());
    }

    private List<WatcheeData> dataToList() {
        ArrayList<WatcheeData> data = new ArrayList<WatcheeData>();
        for (WatcheeData wd : this.finder.data()) {
            data.add(wd);
        }
        return data;
    }

    @Test
    public void simpleFinderTest() {
        try {
            ClassPathFilter filter = new ClassPathFilter("watcherOOP.test.SimpleWatcher");
            this.finder.addPathToSearch(this.classpath.getCanonicalPath());
            this.finder.run(this.classpath.getCanonicalPath(), filter);
            List<WatcheeData> data = this.dataToList();
            Assert.assertEquals((long)1L, (long)data.size());
            Assert.assertEquals((long)2L, (long)data.get((int)0).fields.size());
        }
        catch (IOException e) {
            Assert.fail();
        }
        catch (ClassNotFoundException e) {
            Assert.fail();
        }
    }

    private WatcheeData findData(String name, List<WatcheeData> list) {
        for (WatcheeData data : list) {
            if (!data.className.equals(name)) continue;
            return data;
        }
        return null;
    }

    private void watcheeTest(String className, List<WatcheeData> list, String ... fields) {
        WatcheeData data = this.findData(className, list);
        Assert.assertNotNull((String)className, (Object)data);
        Assert.assertEquals((long)fields.length, (long)data.fields.size());
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            Assert.assertTrue((String)(String.valueOf(className) + ": " + field), (boolean)data.fields.contains(field));
            ++n2;
        }
    }

    @Test
    public void test2Level() {
        try {
            this.finder.addPathToSearch(this.classpath.getCanonicalPath());
            ClassPathFilter filter = new ClassPathFilter("watcherOOP.test.OOPWatcher");
            this.finder.run(this.classpath.getCanonicalPath(), filter);
            List<WatcheeData> data = this.dataToList();
            Assert.assertEquals((long)4L, (long)data.size());
            this.watcheeTest("watcherOOP.test.SimpleWatchee", data, "val", "str");
            this.watcheeTest("watcherOOP.test.WatcheeRoot", data, "val");
            this.watcheeTest("watcherOOP.test.WatcheeChildA", data, "val");
            this.watcheeTest("watcherOOP.test.WatcheeChildC", data, "val");
        }
        catch (IOException e) {
            Assert.fail();
        }
        catch (ClassNotFoundException e) {
            Assert.fail();
        }
    }

    private int getDataOrderIndex(List<WatcheeData> list, String name) {
        int i = 0;
        while (i < list.size()) {
            if (list.get((int)i).className.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Test
    public void test3Level() {
        try {
            this.finder.addPathToSearch(this.classpath.getCanonicalPath());
            ClassPathFilter filter = new ClassPathFilter("watcherOOP.test.OOPWatcherOnC");
            this.finder.run(this.classpath.getCanonicalPath(), filter);
            List<WatcheeData> data = this.dataToList();
            Assert.assertEquals((long)4L, (long)data.size());
            this.watcheeTest("watcherOOP.test.SimpleWatchee", data, "val", "str");
            this.watcheeTest("watcherOOP.test.WatcheeRoot", data, "val");
            this.watcheeTest("watcherOOP.test.WatcheeChildA", data, "val");
            this.watcheeTest("watcherOOP.test.WatcheeChildC", data, "val", "cStr");
            int rootIndex = this.getDataOrderIndex(data, "watcherOOP.test.WatcheeRoot");
            int aIndex = this.getDataOrderIndex(data, "watcherOOP.test.WatcheeChildA");
            int cIndex = this.getDataOrderIndex(data, "watcherOOP.test.WatcheeChildC");
            Assert.assertTrue((rootIndex < aIndex ? 1 : 0) != 0);
            Assert.assertTrue((aIndex < cIndex ? 1 : 0) != 0);
        }
        catch (IOException e) {
            Assert.fail();
        }
        catch (ClassNotFoundException e) {
            Assert.fail();
        }
    }

    @Test
    public void testMultChildren() {
        try {
            this.finder.addPathToSearch(this.classpath.getCanonicalPath());
            ClassPathFilter filter = new ClassPathFilter("watcherOOP.test.OOPWatcherOn*");
            this.finder.run(this.classpath.getCanonicalPath(), filter);
            List<WatcheeData> data = this.dataToList();
            Assert.assertEquals((long)5L, (long)data.size());
            this.watcheeTest("watcherOOP.test.SimpleWatchee", data, "val", "str");
            this.watcheeTest("watcherOOP.test.WatcheeRoot", data, "val", "dVal");
            this.watcheeTest("watcherOOP.test.WatcheeChildB", data, "iVal", "dVal");
            this.watcheeTest("watcherOOP.test.WatcheeChildC", data, "val", "cStr");
            this.watcheeTest("watcherOOP.test.WatcheeChildA", data, "val");
            int rootIndex = this.getDataOrderIndex(data, "watcherOOP.test.WatcheeRoot");
            int aIndex = this.getDataOrderIndex(data, "watcherOOP.test.WatcheeChildA");
            int cIndex = this.getDataOrderIndex(data, "watcherOOP.test.WatcheeChildC");
            int bIndex = this.getDataOrderIndex(data, "watcherOOP.test.WatcheeChildB");
            Assert.assertTrue((rootIndex < aIndex ? 1 : 0) != 0);
            Assert.assertTrue((rootIndex < bIndex ? 1 : 0) != 0);
            Assert.assertTrue((String)(String.valueOf(aIndex) + ", " + cIndex), (aIndex < cIndex ? 1 : 0) != 0);
        }
        catch (IOException e) {
            Assert.fail();
        }
        catch (ClassNotFoundException e) {
            Assert.fail();
        }
    }
}

