/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import repast.simphony.engine.watcher.WatcheeData;
import repast.simphony.engine.watcher.WatcheeDataNode;
import repast.simphony.engine.watcher.WatcheeInstrumentor;
import repast.simphony.filter.Filter;
import simphony.util.messages.MessageCenter;

public class WatcheeDataFinder {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(WatcheeDataFinder.class);
    private Map<String, WatcheeData> watchees = new HashMap<String, WatcheeData>();
    private Map<String, ClassData> classMap = new HashMap<String, ClassData>();
    private List<String> watcherPaths = new ArrayList<String>();
    private Map<String, WatcheeDataNode> nodeMap = new HashMap<String, WatcheeDataNode>();
    private WatcheeInstrumentor instrumentor;

    public WatcheeDataFinder(WatcheeInstrumentor watcheeInstrumentor) {
        this.instrumentor = watcheeInstrumentor;
    }

    public void addClassToFind(String className, String fieldName) {
        WatcheeData data = this.watchees.get(className);
        if (data == null) {
            data = new WatcheeData(className);
            this.watchees.put(className, data);
        }
        data.addField(fieldName);
    }

    public void addPathToSearch(String path) {
        this.watcherPaths.add(path);
    }

    public FinderResult run(String classpath, Filter<String> filter) throws IOException, ClassNotFoundException {
        this.findClasses(this.watcherPaths);
        this.findWatches(filter);
        String[] paths = classpath.split(File.pathSeparator);
        this.findClasses(Arrays.asList(paths));
        ArrayList<String> missingClasses = new ArrayList<String>();
        for (WatcheeData data : this.watchees.values()) {
            ClassData classData = this.classMap.get(data.className);
            if (classData == null) {
                missingClasses.add(data.className);
                continue;
            }
            data.path = classData.path;
        }
        if (!missingClasses.isEmpty()) {
            return new FinderResult(false, "Unable to find class(es) to watch: " + missingClasses);
        }
        for (WatcheeData data : this.watchees.values()) {
            WatcheeDataNode node = new WatcheeDataNode(data);
            this.nodeMap.put(data.className, node);
        }
        this.findSuperClasses();
        this.findSubClasses();
        this.classMap.clear();
        return new FinderResult(true, "");
    }

    private void showSuperSearchError(String cname, List<String> fields) {
        if (cname.equals("java.lang.Object")) {
            for (String field : fields) {
                msg.warn((Object)("Watched field '" + field + "' could not be found."), new Object[0]);
            }
        } else {
            msg.warn((Object)("Cannot find super classes to instrument: " + cname), new Object[0]);
        }
    }

    private Map<String, WatcheeData> findSubClasses() {
        HashMap<String, WatcheeData> watcheeMap = new HashMap<String, WatcheeData>();
        for (ClassData data : this.classMap.values()) {
            if (watcheeMap.containsKey(data.name)) continue;
            this.findParents(data, watcheeMap);
        }
        return watcheeMap;
    }

    private void findParents(ClassData data, Map<String, WatcheeData> watcheeMap) {
        ArrayList<ClassData> hList = new ArrayList<ClassData>();
        WatcheeData watchee = null;
        while (data != null && watchee == null) {
            watchee = this.watchees.get(data.name);
            if (watchee != null) continue;
            hList.add(data);
            data = this.classMap.get(data.superName);
        }
        if (watchee != null) {
            WatcheeDataNode parentNode = this.nodeMap.get(watchee.className);
            int i = hList.size() - 1;
            while (i >= 0) {
                ClassData child = (ClassData)hList.get(i);
                WatcheeDataNode childNode = this.nodeMap.get(child.name);
                if (childNode == null) {
                    WatcheeData childWatchee = child.createWatcheeData();
                    watcheeMap.put(child.name, childWatchee);
                    childNode = new WatcheeDataNode(childWatchee);
                    parentNode.addChild(childNode);
                }
                childNode.data.addFields(parentNode.data.fields);
                parentNode = childNode;
                --i;
            }
        }
    }

    private void addSuperClassData(WatcheeData data, Map<String, WatcheeData> watcheeMap) throws IOException {
        DataInputStream stream = new DataInputStream(data.path.openStream());
        ClassFile cf = new ClassFile(stream);
        stream.close();
        List fields = cf.getFields();
        ArrayList<String> missingFields = new ArrayList<String>();
        for (String field : data.fields) {
            if (this.containsField(fields, field)) continue;
            missingFields.add(field);
        }
        if (missingFields.size() > 0) {
            String superName = cf.getSuperclass();
            WatcheeData parentData = watcheeMap.get(superName);
            if (parentData == null) {
                ClassData proto = this.classMap.get(superName);
                if (proto == null) {
                    this.showSuperSearchError(superName, missingFields);
                } else {
                    parentData = proto.createWatcheeData();
                    watcheeMap.put(parentData.className, parentData);
                }
            }
            parentData.addFields(missingFields);
            WatcheeDataNode parent = this.nodeMap.get(superName);
            if (parent == null) {
                parent = new WatcheeDataNode(parentData);
                this.nodeMap.put(superName, parent);
            }
            parent.addChild(this.nodeMap.get(data.className));
            this.addSuperClassData(parentData, watcheeMap);
        }
    }

    private Map<String, WatcheeData> findSuperClasses() throws IOException {
        HashMap<String, WatcheeData> watcheeMap = new HashMap<String, WatcheeData>();
        for (WatcheeData data : this.watchees.values()) {
            if (!watcheeMap.containsKey(data.className)) {
                watcheeMap.put(data.className, data);
            }
            this.addSuperClassData(data, watcheeMap);
        }
        return watcheeMap;
    }

    private void addClassToMap(String name, URL path) {
        ClassData data = new ClassData(name, path);
        try {
            DataInputStream stream = new DataInputStream(data.path.openStream());
            ClassFile cf = new ClassFile(stream);
            stream.close();
            data.superName = cf.getSuperclass();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.classMap.put(name, data);
    }

    private void findClasses(List<String> paths) throws IOException {
        for (String path : paths) {
            File file = new File(path);
            if (file.getName().endsWith(".jar") && file.exists()) {
                JarFile jar = new JarFile(path);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    String clazz = name.substring(0, name.length() - 6);
                    clazz = clazz.replace("/", ".");
                    StringBuilder builder = new StringBuilder("jar:file:");
                    String cPath = file.getCanonicalPath();
                    if (!cPath.startsWith(File.separator)) {
                        builder.append("/");
                    }
                    builder.append(cPath);
                    builder.append("!/");
                    builder.append(name);
                    this.addClassToMap(clazz, new URL(builder.toString()));
                }
                continue;
            }
            if (!file.exists() || !file.isDirectory()) continue;
            int index = file.getCanonicalPath().length() + 1;
            this.findClasses(file, index);
        }
    }

    private void findClasses(File directory, int start) throws IOException {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.findClasses(file, start);
            } else if (file.getName().endsWith(".class")) {
                String clazz = file.getCanonicalPath().substring(start);
                clazz = clazz.substring(0, clazz.length() - 6);
                clazz = clazz.replace(File.separator, ".");
                this.addClassToMap(clazz, file.toURI().toURL());
            }
            ++n2;
        }
    }

    private boolean containsField(List<FieldInfo> fields, String name) {
        for (FieldInfo field : fields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Iterable<WatcheeData> data() {
        NodeIterator iter = new NodeIterator(this.nodeMap.values());
        return iter;
    }

    private void findWatches(Filter<String> filter) throws IOException, ClassNotFoundException {
        ClassPool pool = ClassPool.getDefault();
        for (ClassData data : this.classMap.values()) {
            CtMethod[] methods;
            if (data.path == null || this.instrumentor.isInstrumented(data.name) || !filter.evaluate(data.name) && !filter.evaluate(data.path.toExternalForm())) continue;
            BufferedInputStream stream = new BufferedInputStream(data.path.openStream());
            CtClass ctClass = pool.makeClass((InputStream)stream);
            stream.close();
            CtMethod[] ctMethodArray = methods = ctClass.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                CtMethod method = ctMethodArray[n2];
                MethodInfo info = method.getMethodInfo();
                AnnotationsAttribute attr = (AnnotationsAttribute)info.getAttribute("RuntimeVisibleAnnotations");
                if (attr != null) {
                    Annotation an = attr.getAnnotation("repast.simphony.engine.watcher.Watch");
                    if (an != null) {
                        String watcheeName = ((StringMemberValue)an.getMemberValue("watcheeClassName")).getValue();
                        String fieldNames = ((StringMemberValue)an.getMemberValue("watcheeFieldNames")).getValue();
                        StringTokenizer tok = new StringTokenizer(fieldNames, ",");
                        while (tok.hasMoreTokens()) {
                            this.addClassToFind(watcheeName, tok.nextToken().trim());
                        }
                    } else {
                        an = attr.getAnnotation("repast.simphony.engine.watcher.WatchItems");
                        if (an != null) {
                            MemberValue[] watches;
                            MemberValue[] memberValueArray = watches = ((ArrayMemberValue)an.getMemberValue("watches")).getValue();
                            int n3 = watches.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                MemberValue value = memberValueArray[n4];
                                Annotation watch = ((AnnotationMemberValue)value).getValue();
                                String watcheeName = ((StringMemberValue)watch.getMemberValue("watcheeClassName")).getValue();
                                String fieldNames = ((StringMemberValue)watch.getMemberValue("watcheeFieldNames")).getValue();
                                StringTokenizer tok = new StringTokenizer(fieldNames, ",");
                                while (tok.hasMoreTokens()) {
                                    this.addClassToFind(watcheeName, tok.nextToken().trim());
                                }
                                ++n4;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private class ClassData {
        String name;
        String superName;
        URL path;

        public ClassData(String name, URL path) {
            this.name = name;
            this.path = path;
        }

        WatcheeData createWatcheeData() {
            WatcheeData data = new WatcheeData(this.name);
            data.path = this.path;
            return data;
        }
    }

    public class FinderResult {
        private boolean ok;
        private String message;

        public FinderResult(boolean result, String message) {
            this.ok = result;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean failed() {
            return !this.ok;
        }
    }

    private static class NodeIterator
    implements Iterator<WatcheeData>,
    Iterable<WatcheeData> {
        private List<WatcheeDataNode> roots = new ArrayList<WatcheeDataNode>();
        private Iterator<WatcheeDataNode> rootIter;
        private Queue<WatcheeDataNode> queue = new LinkedList<WatcheeDataNode>();
        private WatcheeDataNode next;

        public NodeIterator(Collection<WatcheeDataNode> nodes) {
            for (WatcheeDataNode node : nodes) {
                if (!node.isRoot()) continue;
                this.roots.add(node);
            }
            this.rootIter = this.roots.iterator();
            if (this.rootIter.hasNext()) {
                this.next = this.rootIter.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        private void updateNext() {
            this.queue.addAll(this.next.children());
            this.next = this.queue.size() > 0 ? this.queue.poll() : (this.rootIter.hasNext() ? this.rootIter.next() : null);
        }

        @Override
        public WatcheeData next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            WatcheeData tmp = this.next.data;
            this.updateNext();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<WatcheeData> iterator() {
            return this;
        }
    }
}

