/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.lang.reflect.Method;
import repast.simphony.engine.schedule.CallBackAction;
import repast.simphony.engine.watcher.ArgMatcher;
import repast.simphony.engine.watcher.DefaultWatchData;
import repast.simphony.engine.watcher.SharedWatchParameters;
import repast.simphony.engine.watcher.WatcherTriggerSchedule;
import repast.simphony.engine.watcher.query.IBooleanExpression;
import simphony.util.messages.MessageCenter;

public class WatchParameters {
    private static MessageCenter msg = MessageCenter.getMessageCenter(WatchParameters.class);
    private String watcherMethodName;
    private Object watcher;
    private CallBackAction action;
    private SharedWatchParameters params;

    WatchParameters(String classToWatch, String fieldToWatch, Object watcher, Method method) {
        this.params = new SharedWatchParameters(classToWatch, fieldToWatch);
        this.watcher = watcher;
        this.watcherMethodName = method.getName();
        this.action = new CallBackAction(watcher, method);
    }

    public WatchParameters(SharedWatchParameters params, CallBackAction action) {
        this.params = params;
        this.action = action;
        this.watcherMethodName = action.getMethodName();
        this.watcher = action.getTarget();
    }

    public Class<?> getWatcheeClass() {
        return this.params.getWatcheeClass();
    }

    public void setTriggerSchedule(WatcherTriggerSchedule schedule, double scheduleDelta, double schedulePriority) {
        this.params.setTriggerSchedule(schedule, scheduleDelta, schedulePriority);
    }

    public WatcherTriggerSchedule getTriggerSchedule() {
        return this.params.getTriggerSchedule();
    }

    public double getScheduleDelta() {
        return this.params.getScheduleDelta();
    }

    public double getSchedulePriority() {
        return this.params.getSchedulePriority();
    }

    public String getWatchID() {
        return this.params.getWatchID();
    }

    public void setWatchID(String watchID) {
        this.params.setWatchID(watchID);
    }

    public String createWatcheeID() {
        return this.params.createWatcheeID();
    }

    public String getWatcheeCondition() {
        return this.params.getWatcheeCondition();
    }

    public void setWatcheeCondition(String watcheeCondition) {
        this.params.setWatcheeCondition(watcheeCondition);
    }

    public String getClassName() {
        return this.params.getClassName();
    }

    public String getFieldName() {
        return this.params.getFieldName();
    }

    public void setArgMatcher(ArgMatcher matcher) {
        this.params.setArgMatcher(matcher);
    }

    public ArgMatcher getArgMatcher() {
        ArgMatcher matcher = this.params.getArgMatcher();
        if (matcher == null) {
            try {
                matcher = new ArgMatcher(new DefaultWatchData(this.getWatchID()));
                matcher.match(this.action.getMethod(), this.getClassName(), this.getFieldName());
                this.params.setArgMatcher(matcher);
            }
            catch (NoSuchFieldException e) {
                msg.error((Object)"Error while creating watch parameters", (Throwable)e, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                msg.error((Object)"Error while creating watch parameters", (Throwable)e, new Object[0]);
            }
        }
        return matcher;
    }

    public Object getWatcher() {
        return this.watcher;
    }

    public String getWatcherMethodName() {
        return this.watcherMethodName;
    }

    public CallBackAction getAction() {
        return this.action;
    }

    public void setQueryCondition(IBooleanExpression condition) {
        this.params.setQueryCondition(condition);
    }

    public IBooleanExpression getQueryCondition() {
        return this.params.getQueryCondition();
    }

    public int getWatcherCount() {
        return this.params.getWatcherCount();
    }

    public void setWatcherCount(int pick) {
        this.params.setWatcherCount(pick);
    }

    public boolean doShuffleWatchers() {
        return this.params.doShuffleWatchers();
    }

    public void setShuffleWatchers(boolean shuffleWatchers) {
        this.params.setShuffleWatchers(shuffleWatchers);
    }
}

