/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.engine.schedule.CallBackAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.watcher.AnnotatedWatchData;
import repast.simphony.engine.watcher.ArgMatcher;
import repast.simphony.engine.watcher.SharedWatchParameters;
import repast.simphony.engine.watcher.Watch;
import repast.simphony.engine.watcher.WatchParameters;
import repast.simphony.engine.watcher.WatcherTrigger;
import repast.simphony.engine.watcher.query.ASTStart;
import repast.simphony.engine.watcher.query.ParseException;
import repast.simphony.engine.watcher.query.QueryParser;
import repast.simphony.engine.watcher.query.TokenMgrError;
import repast.simphony.util.collections.Pair;
import simphony.util.messages.MessageCenter;

public class WatchContextListener
implements ContextListener<Object> {
    private static MessageCenter msg = MessageCenter.getMessageCenter(WatchContextListener.class);
    private ISchedule schedule;
    private Map<Class<?>, List<Pair<Method, Watch>>> watchMap;
    private Map<Method, CacheEntries> parameterCache = new HashMap<Method, CacheEntries>();

    public WatchContextListener(ISchedule schedule, Map<Class<?>, List<Pair<Method, Watch>>> watchMap) {
        this.schedule = schedule;
        this.watchMap = watchMap;
    }

    private ArgMatcher createArgMatcher(Method method, Watch watch) {
        int numParams = method.getParameterTypes().length;
        ArgMatcher matcher = new ArgMatcher(new AnnotatedWatchData(watch));
        if (numParams > 0) {
            try {
                StringTokenizer tok = new StringTokenizer(watch.watcheeFieldNames(), ",");
                boolean matched = false;
                while (tok.hasMoreTokens()) {
                    matched = matcher.match(method, watch.watcheeClassName(), tok.nextToken().trim());
                    if (matched) break;
                }
                if (!matched) {
                    RuntimeException ex = new RuntimeException("Error in watcher method parameters");
                    msg.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                    throw ex;
                }
            }
            catch (ClassNotFoundException e) {
                msg.error((Object)"Error while setting up watcher", (Throwable)e, new Object[0]);
            }
            catch (NoSuchFieldException e) {
                msg.error((Object)"Error while setting up watcher", (Throwable)e, new Object[0]);
            }
        }
        return matcher;
    }

    private List<WatchParameters> createWatchParameters(Object obj, Pair<Method, Watch> data, Context<? extends Object> context) {
        boolean createCacheEntry;
        ArrayList<WatchParameters> wps = new ArrayList<WatchParameters>();
        Method method = data.getFirst();
        Watch watch = data.getSecond();
        CacheEntries entries = this.parameterCache.get(method);
        boolean bl = createCacheEntry = entries == null;
        if (entries != null) {
            CallBackAction action = new CallBackAction(obj, method);
            boolean bl2 = createCacheEntry = !entries.addWPS(watch, action, wps);
        }
        if (createCacheEntry) {
            ArgMatcher matcher = this.createArgMatcher(method, watch);
            CallBackAction action = new CallBackAction(obj, method);
            String fieldNames = watch.watcheeFieldNames();
            StringTokenizer tok = new StringTokenizer(fieldNames, ",");
            while (tok.hasMoreTokens()) {
                String fieldName = tok.nextToken().trim();
                SharedWatchParameters proto = new SharedWatchParameters(watch.watcheeClassName(), fieldName);
                WatchParameters wp = new WatchParameters(proto, action);
                wp.setWatcheeCondition(watch.triggerCondition());
                wp.setTriggerSchedule(watch.whenToTrigger(), watch.scheduleTriggerDelta(), watch.scheduleTriggerPriority());
                wp.setWatcherCount(watch.pick());
                wp.setShuffleWatchers(watch.shuffle());
                String query = watch.query();
                if (query.trim().length() > 0) {
                    this.processQuery(query, wp, context);
                }
                wp.setArgMatcher(matcher);
                wps.add(wp);
                if (entries == null) {
                    entries = new CacheEntries();
                    this.parameterCache.put(method, entries);
                }
                entries.addEntry(new CacheEntry(watch, proto));
            }
        }
        return wps;
    }

    private void processQuery(String query, WatchParameters wp, Context<? extends Object> context) {
        QueryParser parser = new QueryParser(new StringReader(String.valueOf(query) + ";"));
        try {
            ASTStart start = parser.Start();
            wp.setQueryCondition(start.buildExpression(context.findParent(wp.getWatcher())));
        }
        catch (TokenMgrError ex) {
            this.handleQueryException(query, ex);
        }
        catch (ParseException ex) {
            this.handleQueryException(query, ex);
        }
    }

    private void handleQueryException(String query, Throwable ex) {
        MessageCenter msgCenter = MessageCenter.getMessageCenter(this.getClass());
        String message = "Invalid query annotation '" + query + "'";
        msgCenter.error((Object)message, ex, new Object[0]);
        throw new RuntimeException(ex);
    }

    @Override
    public void eventOccured(ContextEvent<Object> event) {
        ContextEvent.EventType type = event.getType();
        Object obj = event.getTarget();
        if (type == ContextEvent.EventType.AGENT_ADDED) {
            this.processObject(obj, event.getContext());
        } else if (type == ContextEvent.EventType.AGENT_REMOVED) {
            WatcherTrigger.getInstance().removeNotifier(obj);
        }
    }

    void processObject(Object obj, Context<? extends Object> context) {
        List<Pair<Method, Watch>> watchData = this.findWatchData(obj.getClass());
        if (watchData != null) {
            for (Pair<Method, Watch> data : watchData) {
                for (WatchParameters wp : this.createWatchParameters(obj, data, context)) {
                    WatcherTrigger.getInstance().addFieldSetWatch(wp, this.schedule);
                }
            }
        }
    }

    List<Pair<Method, Watch>> findWatchData(Class<?> clazz) {
        List<Pair<Method, Watch>> watchData = this.watchMap.get(clazz);
        if (watchData == null) {
            for (Class<?> key : this.watchMap.keySet()) {
                if (!key.isAssignableFrom(clazz)) continue;
                watchData = this.watchMap.get(key);
                this.watchMap.put(clazz, watchData);
                break;
            }
        }
        return watchData;
    }

    private static class CacheEntries {
        List<CacheEntry> entries = new ArrayList<CacheEntry>();

        private CacheEntries() {
        }

        public void addEntry(CacheEntry entry) {
            this.entries.add(entry);
        }

        public boolean addWPS(Watch watch, CallBackAction action, List<WatchParameters> wps) {
            boolean watchFound = false;
            for (CacheEntry entry : this.entries) {
                if (!entry.watch.equals(watch)) continue;
                watchFound = true;
                wps.add(new WatchParameters(entry.params, action));
                break;
            }
            return watchFound;
        }
    }

    private static class CacheEntry {
        SharedWatchParameters params;
        Watch watch;

        public CacheEntry(Watch watch, SharedWatchParameters params) {
            this.watch = watch;
            this.params = params;
        }
    }
}

