/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.ContextListener;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.watcher.Watch;
import repast.simphony.engine.watcher.WatchContextListener;
import repast.simphony.engine.watcher.WatchItems;
import repast.simphony.util.collections.Pair;

public class WatchAnnotationReader {
    private WatchContextListener contextListener;
    private Map<Class<?>, List<Pair<Method, Watch>>> watchMap = new HashMap();

    public void processClass(Class<?> clazz) {
        this.findWatchAnnotation(clazz);
    }

    public void processClasses(List<Class<?>> clazzes) {
        for (Class<?> clazz : clazzes) {
            this.processClass(clazz);
        }
    }

    private void findWatchAnnotation(Class<?> clazz) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Watch watch = method.getAnnotation(Watch.class);
            if (watch != null) {
                this.processWatch(watch, clazz, method);
            } else {
                WatchItems items = method.getAnnotation(WatchItems.class);
                if (items != null) {
                    Watch[] watchArray = items.watches();
                    int n3 = watchArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Watch aWatch = watchArray[n4];
                        this.processWatch(aWatch, clazz, method);
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public int watchCount() {
        return this.watchMap.values().size();
    }

    private void processWatch(Watch watch, Class<?> clazz, Method method) {
        List<Pair<Method, Watch>> list = this.watchMap.get(clazz);
        if (list == null) {
            list = new ArrayList<Pair<Method, Watch>>();
            this.watchMap.put(clazz, list);
        }
        list.add(new Pair<Method, Watch>(method, watch));
    }

    public void processObjectAsWatcher(Object object, ISchedule schedule, Context<Object> context) {
        this.getContextListener(schedule);
        this.contextListener.processObject(object, context);
    }

    public ContextListener getContextListener(ISchedule schedule) {
        if (this.contextListener == null) {
            this.contextListener = new WatchContextListener(schedule, this.watchMap);
        }
        return this.contextListener;
    }

    public void reset() {
        this.contextListener = null;
    }
}

