/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.lang.reflect.Field;
import repast.simphony.engine.watcher.ArgMatcher;
import repast.simphony.engine.watcher.WatcherTriggerSchedule;
import repast.simphony.engine.watcher.query.DefaultBooleanExpression;
import repast.simphony.engine.watcher.query.IBooleanExpression;

public class SharedWatchParameters {
    private String className;
    private String fieldName;
    private String watcheeCondition = "";
    private double schedulePriority;
    private double scheduleDelta;
    private WatcherTriggerSchedule triggerSchedule = WatcherTriggerSchedule.IMMEDIATE;
    private IBooleanExpression queryCondition = new DefaultBooleanExpression();
    private String watchID = "";
    private int pick = Integer.MAX_VALUE;
    private boolean shuffleWatchers = true;
    private ArgMatcher matcher = null;
    private String declaringClass;
    private Class<?> watcheeClass;

    public SharedWatchParameters(String classToWatch, String fieldToWatch) {
        this.className = classToWatch;
        this.declaringClass = null;
        this.fieldName = fieldToWatch;
        try {
            this.watcheeClass = Class.forName(classToWatch);
            Class<?> clazz = this.watcheeClass;
            while (clazz != null) {
                Field[] fields;
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (field.getName().equals(fieldToWatch)) {
                        this.declaringClass = clazz.getName();
                        break;
                    }
                    ++n2;
                }
                if (this.declaringClass == null) {
                    clazz = clazz.getSuperclass();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Class<?> getWatcheeClass() {
        return this.watcheeClass;
    }

    public void setArgMatcher(ArgMatcher matcher) {
        this.matcher = matcher;
    }

    public ArgMatcher getArgMatcher() {
        return this.matcher;
    }

    public void setTriggerSchedule(WatcherTriggerSchedule schedule, double scheduleDelta, double schedulePriority) {
        this.scheduleDelta = scheduleDelta;
        this.schedulePriority = schedulePriority;
        this.triggerSchedule = schedule;
    }

    public WatcherTriggerSchedule getTriggerSchedule() {
        return this.triggerSchedule;
    }

    public double getScheduleDelta() {
        return this.scheduleDelta;
    }

    public double getSchedulePriority() {
        return this.schedulePriority;
    }

    public String getWatchID() {
        return this.watchID;
    }

    public void setWatchID(String watchID) {
        this.watchID = watchID;
    }

    public String createWatcheeID() {
        return String.valueOf(this.declaringClass) + "." + this.fieldName;
    }

    public String getWatcheeCondition() {
        return this.watcheeCondition;
    }

    public void setWatcheeCondition(String watcheeCondition) {
        this.watcheeCondition = watcheeCondition;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setQueryCondition(IBooleanExpression condition) {
        this.queryCondition = condition;
    }

    public IBooleanExpression getQueryCondition() {
        return this.queryCondition;
    }

    public int getWatcherCount() {
        return this.pick;
    }

    public void setWatcherCount(int pick) {
        this.pick = pick;
    }

    public boolean doShuffleWatchers() {
        return this.shuffleWatchers;
    }

    public void setShuffleWatchers(boolean shuffleWatchers) {
        this.shuffleWatchers = shuffleWatchers;
    }
}

