/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.lang.reflect.Method;
import repast.simphony.engine.watcher.WatchParameters;
import repast.simphony.engine.watcher.WatcherTriggerSchedule;

public class NotifierID {
    private Class<?> watcherClass;
    private Method watcherMethod;
    private String watcheeID;
    private String query;
    private String triggerExp;
    private String watchID;
    private double schDelta;
    private double schPriority;
    private WatcherTriggerSchedule triggerSchedule;
    private int hashCode;
    private boolean shuffle;

    public NotifierID(WatchParameters params) {
        long l;
        this.watcheeID = params.createWatcheeID();
        this.watcherClass = params.getWatcher().getClass();
        this.watcherMethod = params.getAction().getMethod();
        this.query = params.getQueryCondition().getExpression();
        this.triggerExp = params.getWatcheeCondition();
        this.schDelta = params.getScheduleDelta();
        this.triggerSchedule = params.getTriggerSchedule();
        this.schPriority = params.getSchedulePriority();
        this.shuffle = params.doShuffleWatchers();
        this.watchID = params.getWatchID();
        this.hashCode = 17;
        this.hashCode = 37 * this.hashCode + this.watcherClass.hashCode();
        this.hashCode = 37 * this.hashCode + this.watcherMethod.hashCode();
        this.hashCode = 37 * this.hashCode + this.watcheeID.hashCode();
        this.hashCode = 37 * this.hashCode + this.query.hashCode();
        this.hashCode = 37 * this.hashCode + this.triggerExp.hashCode();
        this.hashCode = 37 * this.hashCode + this.triggerSchedule.hashCode();
        this.hashCode = 37 * this.hashCode + this.watchID.hashCode();
        this.hashCode = 37 * this.hashCode + (this.shuffle ? 1 : 0);
        if (!Double.isNaN(this.schPriority)) {
            l = Double.doubleToLongBits(this.schPriority);
            this.hashCode = 37 * this.hashCode + (int)(l ^ l >>> 32);
        }
        l = Double.doubleToLongBits(this.schDelta);
        this.hashCode = 37 * this.hashCode + (int)(l ^ l >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NotifierID)) {
            return false;
        }
        NotifierID other = (NotifierID)obj;
        if (Double.isNaN(this.schPriority) && !Double.isNaN(other.schPriority)) {
            return false;
        }
        if (!Double.isNaN(this.schPriority) && Double.isNaN(other.schPriority)) {
            return false;
        }
        if (!Double.isNaN(this.schPriority) && !Double.isNaN(other.schPriority) && this.schPriority != other.schPriority) {
            return false;
        }
        return this.watcherClass.equals(other.watcherClass) && this.watcherMethod.equals(other.watcherMethod) && this.watcheeID.equals(other.watcheeID) && this.schDelta == other.schDelta && this.query.equals(other.query) && this.watchID.equals(other.watchID) && this.triggerExp.equals(other.triggerExp) && this.triggerSchedule == other.triggerSchedule && this.shuffle == other.shuffle;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

