/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import repast.simphony.engine.schedule.CallBackAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.watcher.DefaultTriggerScheduler;
import repast.simphony.engine.watcher.ImmediateExecutor;
import repast.simphony.engine.watcher.NotifierID;
import repast.simphony.engine.watcher.NotifierTrigger;
import repast.simphony.engine.watcher.TriggerScheduler;
import repast.simphony.engine.watcher.WatchParameters;
import repast.simphony.engine.watcher.WatcherTriggerSchedule;
import repast.simphony.engine.watcher.query.AndBooleanCondition;
import repast.simphony.engine.watcher.query.BooleanExpressionCreator;
import repast.simphony.engine.watcher.query.DefaultBooleanExpression;
import repast.simphony.engine.watcher.query.IBooleanExpression;
import repast.simphony.random.RandomHelper;
import repast.simphony.util.ClassUtilities;
import repast.simphony.util.SimUtilities;
import simphony.util.messages.MessageCenter;

public class Notifier2 {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(Notifier2.class);
    private Set<Object> watchers = new LinkedHashSet<Object>();
    private NotifierID id;
    private ISchedule schedule;
    private WatchParameters watchParams;
    private TriggerScheduler triggerScheduler = new SetupTrigger();
    private CallBackAction action;

    public Notifier2(NotifierID id, WatchParameters params, ISchedule schedule) {
        this.id = id;
        this.schedule = schedule;
        this.watchers.add(params.getWatcher());
        this.watchParams = params;
    }

    private void createAction() {
        this.action = this.watchParams.getAction();
        if (this.action == null) {
            String methodName = this.watchParams.getWatcherMethodName();
            Object toNotify = this.watchParams.getWatcher();
            this.action = new CallBackAction(toNotify, methodName, new Object[0]);
        }
    }

    public Iterable<Object> watchers(boolean shuffle) {
        if (shuffle) {
            ArrayList<Object> list = new ArrayList<Object>(this.watchers);
            SimUtilities.shuffle(list, RandomHelper.getUniform());
            return list;
        }
        return this.watchers;
    }

    public int getWatcherCount() {
        return this.watchers.size();
    }

    public void addWatcher(Object watcher) {
        this.watchers.add(watcher);
    }

    public void triggered(Object watchee, Object value) {
        if (this.watchParams.getWatcheeClass().isAssignableFrom(watchee.getClass())) {
            this.triggerScheduler.scheduleExecution(this, watchee, value);
        }
    }

    public void removeWatcher(Object watcher) {
        this.watchers.remove(watcher);
    }

    private TriggerScheduler createTriggerScheduler(IBooleanExpression condition, NotifierTrigger trigger) {
        AndBooleanCondition andCondition = new AndBooleanCondition(this.watchParams.getQueryCondition(), condition);
        if (this.watchParams.getTriggerSchedule() == WatcherTriggerSchedule.IMMEDIATE) {
            return new ImmediateExecutor(trigger, andCondition, this.watchParams.getWatcherCount(), this.watchParams.doShuffleWatchers());
        }
        return new DefaultTriggerScheduler(trigger, this.schedule, this.watchParams, andCondition);
    }

    static class SetupTrigger
    implements TriggerScheduler {
        SetupTrigger() {
        }

        @Override
        public void scheduleExecution(Notifier2 notifier, Object watchee, Object value) {
            try {
                notifier.createAction();
                IBooleanExpression condition = new DefaultBooleanExpression();
                String watcheeCondition = notifier.watchParams.getWatcheeCondition();
                if (watcheeCondition != null && watcheeCondition.length() > 0) {
                    BooleanExpressionCreator creator = new BooleanExpressionCreator();
                    Class clazz = ClassUtilities.deepFindField(watchee.getClass(), notifier.watchParams.getFieldName()).getType();
                    clazz = ClassUtils.primitiveToWrapper(clazz);
                    condition = creator.create(notifier.id, watcheeCondition, notifier.watchParams.getWatcher().getClass(), watchee.getClass(), clazz);
                }
                NotifierTrigger trigger = notifier.watchParams.getArgMatcher().createTrigger(notifier.action);
                notifier.triggerScheduler = notifier.createTriggerScheduler(condition, trigger);
                notifier.triggerScheduler.scheduleExecution(notifier, watchee, value);
            }
            catch (Exception ex) {
                msg.error((Object)"Error while initializing watcher triggerScheduler", (Throwable)ex, new Object[0]);
            }
        }
    }
}

