/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.BasicConfigurator;
import repast.simphony.engine.watcher.query.BooleanExpressionCreator;
import repast.simphony.engine.watcher.query.IBooleanExpression;

public class ExpressionCreatorTest
extends TestCase {
    static {
        BasicConfigurator.configure();
    }

    public void testInteger() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            IBooleanExpression exp = creator.create("IntegerTest", "$field > 3", Object.class, Object.class, Integer.class);
            boolean result = exp.execute(new Object(), new Object(), new Integer(6));
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void testDouble() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            IBooleanExpression exp = creator.create("DoubleTest", "$field < 3.53", Object.class, Object.class, Double.class);
            boolean result = exp.execute(new Object(), new Object(), new Double(3.5));
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void testFloat() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            IBooleanExpression exp = creator.create("FloatTest", "$field < 3.53", Object.class, Object.class, Float.class);
            boolean result = exp.execute(new Object(), new Object(), new Float(3.5));
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testLong() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            IBooleanExpression exp = creator.create("LongTest", "$field < 3.53", Object.class, Object.class, Long.class);
            boolean result = exp.execute(new Object(), new Object(), new Long(-22L));
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testShort() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            IBooleanExpression exp = creator.create("ShortTest", "$field < 3.53", Object.class, Object.class, Short.class);
            boolean result = exp.execute(new Object(), new Object(), new Short("2"));
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testByte() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            IBooleanExpression exp = creator.create("ByteTest", "$field < 3.53", Object.class, Object.class, Byte.class);
            boolean result = exp.execute(new Object(), new Object(), new Byte("-22"));
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testBoolean() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            IBooleanExpression exp = creator.create("BooleanTest", "$field", Object.class, Object.class, Boolean.class);
            boolean result = exp.execute(new Object(), new Object(), Boolean.TRUE);
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testEquals() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            Integer zero = new Integer(0);
            Integer twenty = new Integer(20);
            IBooleanExpression exp = creator.create("MethodCallTest", "$watcher == $watchee", Integer.class, Integer.class, Integer.class);
            boolean result = exp.execute(zero, twenty, new Integer(-1));
            ExpressionCreatorTest.assertFalse((boolean)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ExpressionCreatorTest.assertTrue((boolean)false);
        }
    }

    public void testMethodCalls() {
        try {
            BooleanExpressionCreator creator = new BooleanExpressionCreator();
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(new Integer(3));
            ArrayList<Double> list2 = new ArrayList<Double>();
            list2.add(new Double(1.3234324E7));
            IBooleanExpression exp = creator.create("MethodCallTest", "((Double)$watcher.get(0)).intValue() > $watchee.size() && $field > -100", List.class, List.class, Long.class);
            boolean result = exp.execute(list2, list, new Long(-22L));
            ExpressionCreatorTest.assertTrue((boolean)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(ExpressionCreatorTest.class);
    }
}

