/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.util.ArrayList;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.watcher.AbstractTriggerScheduler;
import repast.simphony.engine.watcher.Notifier2;
import repast.simphony.engine.watcher.NotifierTrigger;
import repast.simphony.engine.watcher.TriggerAction;
import repast.simphony.engine.watcher.WatchParameters;
import repast.simphony.engine.watcher.query.IBooleanExpression;
import repast.simphony.random.RandomHelper;
import repast.simphony.util.SimUtilities;

public class DefaultTriggerScheduler
extends AbstractTriggerScheduler {
    private ISchedule schedule;
    private double delta;
    private double priority;

    public DefaultTriggerScheduler(NotifierTrigger trigger, ISchedule schedule, WatchParameters watchParams, IBooleanExpression condition) {
        super(trigger, condition, watchParams.getWatcherCount(), watchParams.doShuffleWatchers());
        this.schedule = schedule;
        this.delta = watchParams.getScheduleDelta();
        this.priority = watchParams.getSchedulePriority();
    }

    @Override
    public void scheduleExecution(Notifier2 notifier, Object watchee, Object value) {
        ArrayList<Object> watchers = new ArrayList<Object>();
        for (Object watcher : notifier.watchers(false)) {
            if (!this.condition.execute(watcher, watchee, value)) continue;
            watchers.add(watcher);
        }
        if (watchers.size() > 0) {
            double start = this.schedule.getTickCount() + this.delta;
            if (watchers.size() > this.amtToTrigger) {
                watchers = new ArrayList(watchers.subList(0, this.amtToTrigger));
            }
            if (this.shuffle) {
                SimUtilities.shuffle(watchers, RandomHelper.getUniform());
            }
            this.schedule.schedule(ScheduleParameters.createOneTime(start, this.priority), new TriggerAction(watchers, watchee, value, this.trigger));
        }
    }
}

