/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.watcher;

import java.lang.reflect.Method;
import java.util.HashSet;
import repast.simphony.engine.schedule.CallBackAction;
import repast.simphony.engine.watcher.NotifierTrigger;
import repast.simphony.engine.watcher.WatchData;
import repast.simphony.util.ClassUtilities;

public class ArgMatcher {
    protected int watcheeIndex = -1;
    protected int dataIndex = -1;
    protected int fieldIndex = -1;
    protected WatchData watchData;

    public ArgMatcher(WatchData watch) {
        this.watchData = watch;
    }

    public NotifierTrigger createTrigger(CallBackAction action) {
        AbstractTrigger trigger = null;
        if (this.watcheeIndex == -1 && this.dataIndex == -1 && this.fieldIndex == -1) {
            trigger = new PlainTrigger();
        } else if (this.watcheeIndex != -1) {
            if (this.dataIndex == -1 && this.fieldIndex == -1) {
                trigger = new SetWatcheeTrigger();
            } else if (this.dataIndex != -1 && this.fieldIndex == -1) {
                trigger = new SetWatcheeDataTrigger(this.watchData, this.dataIndex, this.fieldIndex, this.watcheeIndex);
            } else if (this.dataIndex == -1 && this.fieldIndex != -1) {
                trigger = new SetWatcheeValueTrigger(this.watchData, this.dataIndex, this.fieldIndex, this.watcheeIndex);
            } else if (this.dataIndex != -1 && this.fieldIndex != -1) {
                trigger = new SetWatcheeDataValueTrigger(this.watchData, this.dataIndex, this.fieldIndex, this.watcheeIndex);
            }
        } else {
            trigger = this.dataIndex != -1 ? (this.fieldIndex == -1 ? new SetDataTrigger(this.watchData) : new SetDataValueTrigger(this.watchData, this.dataIndex, this.fieldIndex, this.watcheeIndex)) : new SetValueTrigger();
        }
        trigger.action = action;
        return trigger;
    }

    public boolean match(Method method, String watcheeName, String fieldNames) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> watchee = Class.forName(watcheeName);
        Class<WatchData> dataClazz = WatchData.class;
        HashSet types = new HashSet();
        types.add(watchee);
        types.add(dataClazz);
        Class<?>[] paramTypes = method.getParameterTypes();
        if (fieldNames.contains(",")) {
            int i = 0;
            while (i < paramTypes.length) {
                Class<?> paramType = paramTypes[i];
                boolean res = types.remove(paramType);
                if (!res) {
                    return false;
                }
                if (paramType.equals(watchee)) {
                    this.watcheeIndex = i;
                } else if (paramType.equals(dataClazz)) {
                    this.dataIndex = i;
                }
                ++i;
            }
        } else {
            Class<?> fieldType = ClassUtilities.deepFindField(watchee, fieldNames).getType();
            types.add(fieldType);
            int i = 0;
            while (i < paramTypes.length) {
                Class<?> paramType = paramTypes[i];
                boolean res = types.remove(paramType);
                if (!res) {
                    return false;
                }
                if (paramType.equals(watchee)) {
                    this.watcheeIndex = i;
                } else if (paramType.equals(dataClazz)) {
                    this.dataIndex = i;
                } else if (paramType.equals(fieldType)) {
                    this.fieldIndex = i;
                }
                ++i;
            }
        }
        return true;
    }

    public int getArgCount() {
        return (this.watcheeIndex != -1 ? 1 : 0) + (this.dataIndex != -1 ? 1 : 0) + (this.fieldIndex != -1 ? 1 : 0);
    }

    static abstract class AbstractSetDataTrigger
    extends AbstractTrigger {
        WatchData data;
        int watcheeIndex;
        int dataIndex;
        int fieldIndex;

        protected AbstractSetDataTrigger(WatchData watch, int dataIndex, int fieldIndex, int watcheeIndex) {
            this.data = watch;
            this.dataIndex = dataIndex;
            this.fieldIndex = fieldIndex;
            this.watcheeIndex = watcheeIndex;
        }
    }

    static abstract class AbstractTrigger
    implements NotifierTrigger {
        protected CallBackAction action;

        AbstractTrigger() {
        }
    }

    static class PlainTrigger
    extends AbstractTrigger {
        PlainTrigger() {
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.execute();
        }
    }

    static class SetDataTrigger
    extends AbstractTrigger {
        private WatchData data;

        public SetDataTrigger(WatchData watch) {
            this.data = watch;
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(0, this.data);
            this.action.execute();
        }
    }

    static class SetDataValueTrigger
    extends AbstractSetDataTrigger {
        public SetDataValueTrigger(WatchData watch, int dataIndex, int fieldIndex, int watcheeIndex) {
            super(watch, dataIndex, fieldIndex, watcheeIndex);
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(this.fieldIndex, value);
            this.action.setArgs(this.dataIndex, this.data);
            this.action.execute();
        }
    }

    static class SetValueTrigger
    extends AbstractTrigger {
        SetValueTrigger() {
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(0, value);
            this.action.execute();
        }
    }

    static class SetWatcheeDataTrigger
    extends AbstractSetDataTrigger {
        public SetWatcheeDataTrigger(WatchData watch, int dataIndex, int fieldIndex, int watcheeIndex) {
            super(watch, dataIndex, fieldIndex, watcheeIndex);
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(this.watcheeIndex, watchee);
            this.action.setArgs(this.dataIndex, this.data);
            this.action.execute();
        }
    }

    static class SetWatcheeDataValueTrigger
    extends AbstractSetDataTrigger {
        public SetWatcheeDataValueTrigger(WatchData watch, int dataIndex, int fieldIndex, int watcheeIndex) {
            super(watch, dataIndex, fieldIndex, watcheeIndex);
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(this.watcheeIndex, watchee);
            this.action.setArgs(this.dataIndex, this.data);
            this.action.setArgs(this.fieldIndex, value);
            this.action.execute();
        }
    }

    static class SetWatcheeTrigger
    extends AbstractTrigger {
        SetWatcheeTrigger() {
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(0, watchee);
            this.action.execute();
        }
    }

    static class SetWatcheeValTrigger
    extends AbstractSetDataTrigger {
        public SetWatcheeValTrigger(WatchData watch, int dataIndex, int fieldIndex, int watcheeIndex) {
            super(watch, dataIndex, fieldIndex, watcheeIndex);
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(this.watcheeIndex, watchee);
            this.action.setArgs(this.fieldIndex, value);
            this.action.execute();
        }
    }

    static class SetWatcheeValueTrigger
    extends AbstractSetDataTrigger {
        public SetWatcheeValueTrigger(WatchData watch, int dataIndex, int fieldIndex, int watcheeIndex) {
            super(watch, dataIndex, fieldIndex, watcheeIndex);
        }

        @Override
        public void execute(Object watcher, Object watchee, Object value) {
            this.action.setTarget(watcher);
            this.action.setArgs(this.watcheeIndex, watchee);
            this.action.setArgs(this.fieldIndex, value);
            this.action.execute();
        }
    }
}

