/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import repast.simphony.engine.schedule.AbstractAction;
import repast.simphony.engine.schedule.ActionQueue;
import repast.simphony.engine.schedule.Frequency;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ScheduleParameters;

public class ThreadedAction
extends AbstractAction {
    static final long serialVersionUID = -2127288227326049810L;
    private IAction action;
    private boolean done = false;
    private Thread runner;
    private double duration;

    public ThreadedAction(ScheduleParameters param, IAction action, long orderIndex) {
        super(param, orderIndex);
        this.duration = param.getDuration();
        this.action = action;
        this.setIsNonModelAction(action);
    }

    private synchronized void done() {
        this.done = true;
        this.notifyAll();
    }

    @Override
    protected void setFrequency(Frequency type) {
        if (type == Frequency.REPEAT) {
            this.rescheduler = new ThreadedIntervalRescheduler();
        } else if (type == Frequency.ONE_TIME) {
            this.rescheduler = new ThreadedAtRescheduler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.runner == null) {
            this.runner = new Thread(new ActionRunner(this.action, this));
            this.runner.setName("ThreadedAction Thread");
            this.runner.start();
        } else {
            try {
                ThreadedAction threadedAction = this;
                synchronized (threadedAction) {
                    while (!this.done) {
                        this.wait();
                    }
                }
                this.runner = null;
                this.done = false;
            }
            catch (InterruptedException ex) {
                this.runner.interrupt();
            }
        }
    }

    static class ActionRunner
    implements Runnable {
        IAction iAction;
        ThreadedAction owner;

        public ActionRunner(IAction action, ThreadedAction owner) {
            this.iAction = action;
            this.owner = owner;
        }

        @Override
        public void run() {
            this.iAction.execute();
            this.owner.done();
        }
    }

    class ThreadedAtRescheduler
    implements AbstractAction.Rescheduler {
        private boolean updated = false;

        ThreadedAtRescheduler() {
        }

        @Override
        public void reschedule(ActionQueue queue) {
            if (!this.updated) {
                ThreadedAction.this.nextTime += ThreadedAction.this.duration;
                queue.toss(ThreadedAction.this);
                this.updated = true;
            }
        }
    }

    class ThreadedIntervalRescheduler
    implements AbstractAction.Rescheduler {
        private boolean updateForEnd = true;

        ThreadedIntervalRescheduler() {
        }

        @Override
        public void reschedule(ActionQueue queue) {
            if (this.updateForEnd) {
                ThreadedAction.this.nextTime += ThreadedAction.this.duration;
                queue.toss(ThreadedAction.this);
                this.updateForEnd = false;
            } else {
                ThreadedAction.this.nextTime += ThreadedAction.this.interval;
                queue.toss(ThreadedAction.this);
                this.updateForEnd = true;
            }
        }
    }
}

