/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import cern.jet.random.Normal;
import cern.jet.random.Poisson;
import cern.jet.random.Uniform;
import repast.simphony.engine.schedule.Frequency;
import repast.simphony.engine.schedule.PriorityType;
import repast.simphony.random.RandomHelper;

public class ScheduleParameters {
    static final long serialVersionUID = 474914325315658328L;
    public static final double NO_DURATION = -1.0;
    public static final double END = Double.POSITIVE_INFINITY;
    public static final double RANDOM_PRIORITY = Double.NaN;
    public static final double FIRST_PRIORITY = Double.POSITIVE_INFINITY;
    public static final double LAST_PRIORITY = Double.NEGATIVE_INFINITY;
    private double start;
    private double interval;
    private double priority;
    private PriorityType pType;
    private double duration = 0.0;
    private Frequency frequency = Frequency.REPEAT;
    private int hashCode = 17;

    protected ScheduleParameters(double start, Frequency frequency, double interval, double priority, PriorityType pType, double duration) {
        this.start = start;
        this.frequency = frequency;
        this.interval = interval;
        this.priority = priority;
        this.duration = duration;
        this.pType = pType == null ? (Double.isNaN(priority) ? PriorityType.RANDOM : (priority == Double.POSITIVE_INFINITY ? PriorityType.FIRST : (priority == Double.NEGATIVE_INFINITY ? PriorityType.LAST : PriorityType.OTHER))) : pType;
        long l = Double.doubleToLongBits(start);
        this.hashCode = 31 * this.hashCode + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(interval);
        this.hashCode = 31 * this.hashCode + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(priority);
        this.hashCode = 31 * this.hashCode + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(duration);
        this.hashCode = 31 * this.hashCode + frequency.hashCode();
        this.hashCode = 31 * this.hashCode + this.pType.hashCode();
    }

    public static boolean isRandomPriority(ScheduleParameters params) {
        return params.getPriorityType() == PriorityType.RANDOM;
    }

    public static ScheduleParameters createRepeating(double start, double interval) {
        return new ScheduleParameters(start, Frequency.REPEAT, interval, Double.NaN, null, -1.0);
    }

    public static ScheduleParameters createRepeating(double start, double interval, PriorityType priorityType) {
        return new ScheduleParameters(start, Frequency.REPEAT, interval, 0.0, priorityType, -1.0);
    }

    public static ScheduleParameters createNormalProbabilityOneTime(double meanStart, double sdStart, double priority) {
        Normal n = RandomHelper.createNormal(meanStart, sdStart);
        return ScheduleParameters.createOneTime(n.nextDouble(), priority);
    }

    public static ScheduleParameters createUniformProbabilityOneTime(double minStart, double maxStart, double priority) {
        Uniform u = RandomHelper.createUniform(minStart, maxStart);
        return ScheduleParameters.createOneTime(u.nextDouble(), priority);
    }

    public static ScheduleParameters createPoissonProbabilityOneTime(double mean, double priority) {
        Poisson p = RandomHelper.createPoisson(mean);
        return ScheduleParameters.createOneTime(p.nextDouble(), priority);
    }

    public static ScheduleParameters createPoissonProbabilityRepeating(double mean, double meanRepeating, double priority) {
        Poisson p = RandomHelper.createPoisson(mean);
        Poisson pRepeating = RandomHelper.createPoisson(meanRepeating);
        return ScheduleParameters.createRepeating(p.nextDouble(), pRepeating.nextDouble(), priority);
    }

    public static ScheduleParameters createNormalProbabilityRepeating(double meanStart, double sdStart, double meanInterval, double sdInterval, double priority) {
        Normal n = RandomHelper.createNormal(meanStart, sdStart);
        Normal interval = RandomHelper.createNormal(meanInterval, sdInterval);
        return ScheduleParameters.createRepeating(n.nextDouble(), interval.nextDouble(), priority);
    }

    public static ScheduleParameters createUniformProbabilityRepeating(double minStart, double maxStart, double minInterval, double maxInterval, double priority) {
        Uniform u = RandomHelper.createUniform(minStart, maxStart);
        Uniform uInterval = RandomHelper.createUniform(minInterval, maxInterval);
        return ScheduleParameters.createRepeating(u.nextDouble(), uInterval.nextDouble(), priority);
    }

    public static ScheduleParameters createRepeating(double start, double interval, double priority) {
        return new ScheduleParameters(start, Frequency.REPEAT, interval, priority, null, -1.0);
    }

    public static ScheduleParameters createRepeating(double start, double interval, double priority, double duration) {
        return new ScheduleParameters(start, Frequency.REPEAT, interval, priority, null, duration);
    }

    public static ScheduleParameters createOneTime(double start) {
        return new ScheduleParameters(start, Frequency.ONE_TIME, 0.0, Double.NaN, null, -1.0);
    }

    public static ScheduleParameters createOneTime(double start, PriorityType type) {
        return new ScheduleParameters(start, Frequency.ONE_TIME, 0.0, 0.0, type, -1.0);
    }

    public static ScheduleParameters createOneTime(double start, double priority) {
        return new ScheduleParameters(start, Frequency.ONE_TIME, 0.0, priority, null, -1.0);
    }

    public static ScheduleParameters createOneTime(double start, double priority, double duration) {
        return new ScheduleParameters(start, Frequency.ONE_TIME, 0.0, priority, null, duration);
    }

    public static ScheduleParameters createAtEnd(double priority) {
        return new ScheduleParameters(Double.POSITIVE_INFINITY, Frequency.ONE_TIME, 0.0, priority, null, -1.0);
    }

    public double getStart() {
        return this.start;
    }

    public PriorityType getPriorityType() {
        if (this.pType == null) {
            this.pType = Double.isNaN(this.priority) ? PriorityType.RANDOM : (this.priority == Double.POSITIVE_INFINITY ? PriorityType.FIRST : (this.priority == Double.NEGATIVE_INFINITY ? PriorityType.LAST : PriorityType.OTHER));
        }
        return this.pType;
    }

    public double getPriority() {
        return this.priority;
    }

    public double getInterval() {
        return this.interval;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public double getDuration() {
        return this.duration;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScheduleParameters)) {
            return false;
        }
        ScheduleParameters otherParams = (ScheduleParameters)obj;
        return otherParams.start == this.start && otherParams.frequency.equals((Object)this.frequency) && otherParams.interval == this.interval && Double.valueOf(otherParams.priority).equals(this.priority) && otherParams.duration == this.duration && otherParams.pType == this.pType;
    }

    public String toString() {
        return String.format("ScheduleParameters[start: %f, frequency: %s, interval: %f, priority: %f, priorityType: %s, duration: %f]", new Object[]{this.start, this.frequency, this.interval, this.priority, this.pType, this.duration});
    }
}

