/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import cern.jet.random.Uniform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import repast.simphony.engine.schedule.ActionList;
import repast.simphony.engine.schedule.ActionQueue;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.PriorityType;
import repast.simphony.random.RandomHelper;

public class ScheduleGroup
implements IAction {
    static final long serialVersionUID = 3192709155891784441L;
    protected int count = 0;
    protected ActionList actions = new ActionList();
    protected ActionList randomActions = new ActionList();
    protected ActionList firstActions = new ActionList();
    protected ActionList firstOfLastActions = new ActionList();
    protected ActionList lastActions = new ActionList();
    protected List<ISchedulableAction> executedActions = new ArrayList<ISchedulableAction>();
    protected boolean finishing = false;
    private boolean executing = false;
    private boolean actionsAddedDuringExec = false;
    private List<ISchedulableAction> actionsAddedWhileExecuting = new ArrayList<ISchedulableAction>();
    private Comparator<ISchedulableAction> iComp = new PriorityComparator();
    private Comparator<ISchedulableAction> oComp = new OrderComparator();

    public void addAction(ISchedulableAction action) {
        if (this.finishing) {
            return;
        }
        if (this.executing) {
            this.actionsAddedDuringExec = true;
            this.actionsAddedWhileExecuting.add(action);
        } else {
            this.doAddAction(action);
        }
    }

    public boolean remove(ISchedulableAction action) {
        boolean retVal = false;
        if (this.randomActions.remove(action)) {
            retVal = true;
            --this.count;
        }
        if (this.firstActions.remove(action)) {
            --this.count;
            retVal = true;
        }
        if (this.lastActions.remove(action)) {
            --this.count;
            retVal = true;
        }
        if (this.firstOfLastActions.remove(action)) {
            --this.count;
            retVal = true;
        }
        if (this.actions.remove(action)) {
            --this.count;
            retVal = true;
        }
        return retVal;
    }

    private void doAddAction(ISchedulableAction action) {
        PriorityType pType = action.getPriorityType();
        if (pType == PriorityType.RANDOM) {
            this.randomActions.add(action);
        } else if (pType == PriorityType.LAST) {
            this.lastActions.add(action);
        } else if (pType == PriorityType.FIRST) {
            this.firstActions.add(action);
        } else if (pType == PriorityType.FIRST_OF_LAST) {
            this.firstOfLastActions.add(action);
        } else {
            this.actions.add(action);
        }
        ++this.count;
    }

    public void clear() {
        this.actions.clear();
        this.randomActions.clear();
        this.firstActions.clear();
        this.lastActions.clear();
        this.firstOfLastActions.clear();
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public boolean hasMoreToExecute() {
        return this.executedActions.size() != this.count;
    }

    private boolean executeList(ActionList list) {
        int i = 0;
        boolean interrupted = false;
        Iterator<ISchedulableAction> iter = list.iterator();
        while (iter.hasNext()) {
            if (this.actionsAddedDuringExec) break;
            ISchedulableAction action = iter.next();
            this.executedActions.add(action);
            action.execute();
            ++i;
        }
        list.delete(i);
        if (this.actionsAddedDuringExec) {
            interrupted = true;
            this.addExecAddedActions();
            this.actionsAddedDuringExec = false;
        }
        return interrupted;
    }

    @Override
    public void execute() {
        this.executing = true;
        boolean interrupted = this.executeList(this.firstActions);
        if (interrupted) {
            return;
        }
        interrupted = this.executeList(this.actions);
        if (interrupted) {
            return;
        }
        interrupted = this.executeList(this.firstOfLastActions);
        if (interrupted) {
            return;
        }
        interrupted = this.executeList(this.lastActions);
        if (interrupted) {
            return;
        }
        if (this.actionsAddedDuringExec) {
            this.addExecAddedActions();
            this.actionsAddedDuringExec = false;
            return;
        }
        this.executing = false;
    }

    private void addExecAddedActions() {
        for (ISchedulableAction action : this.actionsAddedWhileExecuting) {
            this.doAddAction(action);
        }
        this.sort();
        this.actionsAddedWhileExecuting.clear();
    }

    public void reschedule(ActionQueue aQueue) {
        if (!this.finishing) {
            for (ISchedulableAction action : this.executedActions) {
                action.reschedule(aQueue);
            }
        }
        this.executedActions.clear();
    }

    public void sort() {
        this.randomActions.sort(this.oComp, false);
        this.firstActions.sort(this.oComp, false);
        this.firstOfLastActions.sort(this.oComp, false);
        this.lastActions.sort(this.oComp, false);
        this.actions.sort(this.oComp, false);
        if (this.actions.size() > 0) {
            this.actions.sort(this.iComp, true);
            int size = this.actions.size();
            Uniform defaultUniform = RandomHelper.getUniform();
            for (ISchedulableAction action : this.randomActions) {
                int index = defaultUniform.nextIntFromTo(0, size);
                if (index == size) {
                    this.actions.addNoSort(action);
                } else {
                    this.actions.addNoSort(index, action);
                }
                ++size;
            }
        } else {
            this.randomActions.shuffle();
            this.actions.addAllNoSort(this.randomActions);
        }
        this.randomActions.clear();
    }

    public void setFinishing(boolean finishing) {
        this.finishing = finishing;
    }

    public boolean isFinishing() {
        return this.finishing;
    }

    static class OrderComparator
    implements Comparator<ISchedulableAction> {
        OrderComparator() {
        }

        @Override
        public int compare(ISchedulableAction o1, ISchedulableAction o2) {
            double index2;
            double index1 = o1.getOrderIndex();
            return index1 < (index2 = (double)o2.getOrderIndex()) ? -1 : (index1 == index2 ? 0 : 1);
        }
    }

    static class PriorityComparator
    implements Comparator<ISchedulableAction> {
        PriorityComparator() {
        }

        @Override
        public int compare(ISchedulableAction o1, ISchedulableAction o2) {
            double index2;
            double index1 = o1.getPriority();
            return index1 < (index2 = o2.getPriority()) ? 1 : (index1 == index2 ? 0 : -1);
        }
    }
}

