/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.util.List;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import repast.simphony.engine.schedule.ActionQueue;
import repast.simphony.engine.schedule.DefaultSchedulableActionFactory;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedulableActionFactory;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleGroup;
import repast.simphony.engine.schedule.ScheduleParameters;

public class Schedule
implements ISchedule {
    static final long serialVersionUID = 7686585829552316670L;
    protected ActionQueue actionQueue;
    protected double tickCount = -1.0;
    protected ScheduleGroup groupToExecute;
    protected ScheduleGroup endActions;
    protected ISchedulableActionFactory actionFactory;
    protected Amount userTimeUnits;

    public Schedule() {
        this(new DefaultSchedulableActionFactory());
    }

    public Schedule(ISchedulableActionFactory factory) {
        this.actionFactory = factory;
        this.actionQueue = new ActionQueue();
        this.groupToExecute = new ScheduleGroup();
        this.endActions = new ScheduleGroup();
    }

    private void setTickCount(double ticks) {
        this.tickCount = Math.max(ticks, 0.0);
    }

    @Override
    public double getTickCount() {
        return this.tickCount;
    }

    @Override
    public Amount getTickCountInTimeUnits() {
        if (this.userTimeUnits == null) {
            return Amount.valueOf(this.tickCount, Unit.ONE);
        }
        return this.userTimeUnits.times(this.tickCount);
    }

    public Double convertTimeUnitsToTicks(Amount timeUnitsToConvert) {
        if (this.userTimeUnits == null || this.userTimeUnits.getEstimatedValue() == 0.0) {
            return timeUnitsToConvert.getEstimatedValue();
        }
        return timeUnitsToConvert.divide(this.userTimeUnits).getEstimatedValue();
    }

    public Amount convertTicksToTimeUnits(double ticks) {
        if (this.userTimeUnits == null) {
            return Amount.valueOf(ticks, Unit.ONE);
        }
        return this.userTimeUnits.times(ticks);
    }

    @Override
    public Amount getTimeUnits() {
        return this.userTimeUnits;
    }

    @Override
    public void setTimeUnits(Amount newUnits) {
        this.userTimeUnits = newUnits;
    }

    @Override
    public int getActionCount() {
        return this.actionQueue.size();
    }

    @Override
    public int getModelActionCount() {
        return this.actionQueue.getModelActionCount();
    }

    public ISchedulableAction peekNextAction() {
        return this.actionQueue.peekMin();
    }

    @Override
    public ISchedulableAction schedule(ScheduleParameters scheduleParams, IAction action) {
        ISchedulableAction sAction = this.actionFactory.createAction(scheduleParams, action);
        this.scheduleAction(sAction);
        return sAction;
    }

    private void scheduleAction(ISchedulableAction sAction) {
        if (sAction.getNextTime() >= this.getTickCount()) {
            if (sAction.getNextTime() == Double.POSITIVE_INFINITY) {
                this.endActions.addAction(sAction);
            } else if (sAction.getNextTime() == this.getTickCount()) {
                this.groupToExecute.addAction(sAction);
            } else {
                this.actionQueue.toss(sAction);
            }
        }
    }

    @Override
    public ISchedulableAction schedule(ScheduleParameters scheduleParams, Object target, String methodName, Object ... methodParams) {
        ISchedulableAction sAction = this.actionFactory.createAction(scheduleParams, target, methodName, methodParams);
        this.scheduleAction(sAction);
        return sAction;
    }

    @Override
    public ISchedulableAction scheduleIterable(ScheduleParameters scheduleParams, Iterable target, String methodName, boolean shuffle, Object ... methodParams) {
        ISchedulableAction sAction = this.actionFactory.createActionForIterable(scheduleParams, target, methodName, shuffle, methodParams);
        this.scheduleAction(sAction);
        return sAction;
    }

    @Override
    public List<ISchedulableAction> schedule(Object obj) {
        List<ISchedulableAction> actions = this.actionFactory.createActions(obj);
        for (ISchedulableAction action : actions) {
            this.scheduleAction(action);
        }
        return actions;
    }

    @Override
    public ISchedulableAction schedule(Object annotatedObj, Object ... parameters) {
        ISchedulableAction sAction;
        if (annotatedObj instanceof ScheduleParameters) {
            Object[] fixParams = new Object[parameters.length - 1];
            if (fixParams.length > 0) {
                System.arraycopy(parameters, 1, fixParams, 0, parameters.length - 1);
            }
            sAction = this.actionFactory.createAction((ScheduleParameters)annotatedObj, parameters[0], fixParams);
        } else {
            sAction = this.actionFactory.createAction(annotatedObj, parameters);
        }
        this.scheduleAction(sAction);
        return sAction;
    }

    @Override
    public ISchedulableAction createAction(ScheduleParameters scheduleParams, Object annotatedObj, Object ... parameters) {
        ISchedulableAction sAction = this.actionFactory.createAction(scheduleParams, annotatedObj, parameters);
        this.scheduleAction(sAction);
        return sAction;
    }

    @Override
    public boolean removeAction(ISchedulableAction action) {
        if (action.getNextTime() == Double.POSITIVE_INFINITY) {
            return this.endActions.remove(action);
        }
        if (action.getNextTime() == this.getTickCount()) {
            return false;
        }
        return this.actionQueue.voidAction(action);
    }

    protected void preExecute() {
        double queueMin = Double.POSITIVE_INFINITY;
        if (this.actionQueue.size() > 0) {
            queueMin = this.actionQueue.peekMin().getNextTime();
        }
        if (queueMin == Double.POSITIVE_INFINITY) {
            this.groupToExecute.clear();
            return;
        }
        double newTick = queueMin;
        this.groupToExecute.clear();
        this.actionQueue.popMin().addForExecution(this.groupToExecute);
        if (this.actionQueue.size() > 0) {
            queueMin = this.actionQueue.peekMin().getNextTime();
            while (queueMin == newTick) {
                this.actionQueue.popMin().addForExecution(this.groupToExecute);
                if (this.actionQueue.size() == 0) break;
                queueMin = this.actionQueue.peekMin().getNextTime();
            }
        }
        if (this.groupToExecute.size() > 0) {
            this.setTickCount(newTick);
        }
    }

    @Override
    public void execute() {
        this.preExecute();
        this.groupToExecute.sort();
        while (this.groupToExecute.hasMoreToExecute()) {
            this.groupToExecute.execute();
        }
        this.groupToExecute.reschedule(this.actionQueue);
    }

    @Override
    public void executeEndActions() {
        this.endActions.sort();
        this.endActions.execute();
    }

    @Override
    public void setFinishing(boolean finishing) {
        this.groupToExecute.setFinishing(finishing);
    }

    @Override
    public boolean isFinishing() {
        return this.groupToExecute.isFinishing();
    }
}

