/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.random.RandomHelper;
import repast.simphony.util.ClassUtilities;
import repast.simphony.util.SimUtilities;

public class IterableCallBackAction
implements IAction {
    private Iterable<Object> target;
    private transient FastMethod method;
    private Object[] args;
    private String methodName;
    private transient IAction executor = new SetupExecutor();
    private boolean shuffle;

    public IterableCallBackAction(Iterable target, String methodName, boolean shuffle, Object ... parameters) {
        this.target = target;
        this.shuffle = shuffle;
        this.methodName = methodName;
        this.args = new Object[parameters.length];
        System.arraycopy(parameters, 0, this.args, 0, parameters.length);
    }

    private void initMethod(Object target, String methodName, Class[] paramTypes) {
        block5: {
            FastClass fClass = FastClass.create(target.getClass());
            try {
                this.method = fClass.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodError er) {
                Method jMethod = ClassUtilities.findMethod(target.getClass(), methodName, paramTypes);
                if (jMethod == null) break block5;
                this.method = FastClass.create(jMethod.getDeclaringClass()).getMethod(jMethod);
            }
        }
        if (this.method == null) {
            String pTypes = "(";
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    pTypes = String.valueOf(pTypes) + ", ";
                }
                pTypes = String.valueOf(pTypes) + paramTypes[i].getName();
                ++i;
            }
            pTypes = String.valueOf(pTypes) + ")";
            throw new IllegalArgumentException("Method " + target.getClass().getName() + "." + methodName + pTypes + " not found!");
        }
    }

    @Override
    public void execute() {
        this.executor.execute();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.executor = new SetupExecutor();
    }

    class NoShuffleExecutor
    implements IAction {
        NoShuffleExecutor() {
        }

        @Override
        public void execute() {
            try {
                for (Object obj : IterableCallBackAction.this.target) {
                    IterableCallBackAction.this.method.invoke(obj, IterableCallBackAction.this.args);
                }
            }
            catch (InvocationTargetException e) {
                System.err.print("Tried to call: " + IterableCallBackAction.this.method.toString());
                e.printStackTrace();
            }
        }
    }

    class SetupExecutor
    implements IAction {
        SetupExecutor() {
        }

        @Override
        public void execute() {
            if (IterableCallBackAction.this.target.iterator().hasNext()) {
                Class[] paramTypes = new Class[IterableCallBackAction.this.args.length];
                int i = 0;
                while (i < IterableCallBackAction.this.args.length) {
                    paramTypes[i] = IterableCallBackAction.this.args[i].getClass();
                    ++i;
                }
                IterableCallBackAction.this.initMethod(IterableCallBackAction.this.target.iterator().next(), IterableCallBackAction.this.methodName, paramTypes);
                if (!IterableCallBackAction.this.shuffle) {
                    IterableCallBackAction.this.executor = new NoShuffleExecutor();
                } else if (IterableCallBackAction.this.target instanceof List) {
                    IterableCallBackAction.this.executor = new ShuffleListExecutor();
                } else {
                    IterableCallBackAction.this.executor = new ShuffleIterableExecutor();
                }
                IterableCallBackAction.this.executor.execute();
            }
        }
    }

    class ShuffleIterableExecutor
    implements IAction {
        ShuffleIterableExecutor() {
        }

        @Override
        public void execute() {
            ArrayList list = new ArrayList();
            for (Object obj : IterableCallBackAction.this.target) {
                list.add(obj);
            }
            SimUtilities.shuffle(list, RandomHelper.getUniform());
            try {
                for (Object obj : list) {
                    IterableCallBackAction.this.method.invoke(obj, IterableCallBackAction.this.args);
                }
            }
            catch (InvocationTargetException e) {
                System.err.print("Tried to call: " + IterableCallBackAction.this.method.toString());
                e.printStackTrace();
            }
        }
    }

    class ShuffleListExecutor
    implements IAction {
        ShuffleListExecutor() {
        }

        @Override
        public void execute() {
            SimUtilities.shuffle((List)IterableCallBackAction.this.target, RandomHelper.getUniform());
            try {
                for (Object obj : IterableCallBackAction.this.target) {
                    IterableCallBackAction.this.method.invoke(obj, IterableCallBackAction.this.args);
                }
            }
            catch (InvocationTargetException e) {
                System.err.print("Tried to call: " + IterableCallBackAction.this.method.toString());
                e.printStackTrace();
            }
        }
    }
}

