/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.util.ClassUtilities;
import simphony.util.messages.MessageCenter;

public class DynamicTargetAction
implements IAction {
    static MessageCenter msgCenter = MessageCenter.getMessageCenter(DynamicTargetAction.class);
    static final long serialVersionUID = 3628821571113796716L;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private Object target;
    private Class<?> targetClass;
    private transient FastMethod method;
    private String methodName;

    public DynamicTargetAction(Method method) {
        this.targetClass = method.getDeclaringClass();
        this.method = FastClass.create(this.targetClass).getMethod(method);
        this.methodName = this.method.getName();
    }

    private void initMethod(String methodName) {
        block3: {
            FastClass fClass = FastClass.create(this.targetClass);
            try {
                this.method = fClass.getMethod(methodName, EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodError er) {
                Method jMethod = ClassUtilities.findMethod(this.target.getClass(), methodName, EMPTY_CLASS_ARRAY);
                if (jMethod == null) break block3;
                this.method = FastClass.create(jMethod.getDeclaringClass()).getMethod(jMethod);
            }
        }
        if (this.method == null) {
            throw new IllegalArgumentException("Method " + this.target.getClass().getName() + "." + methodName + "." + " not found!");
        }
    }

    @Override
    public void execute() {
        try {
            this.method.invoke(this.target, (Object[])EMPTY_CLASS_ARRAY);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initMethod(this.methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setTarget(Object obj) {
        this.target = obj;
    }

    public Object getTarget() {
        return this.target;
    }
}

