/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.engine.schedule.DefaultAction;
import repast.simphony.engine.schedule.DefaultActionFactory;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.IActionFactory;
import repast.simphony.engine.schedule.IActionParameterPair;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedulableActionFactory;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.schedule.ThreadedAction;

public class DefaultSchedulableActionFactory
implements ISchedulableActionFactory {
    static final long serialVersionUID = 3797781891538451949L;
    protected IActionFactory actionFactory;
    protected long currentOrderIndex = 0L;

    public DefaultSchedulableActionFactory() {
        this(new DefaultActionFactory());
    }

    public DefaultSchedulableActionFactory(IActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    @Override
    public ISchedulableAction createAction(ScheduleParameters scheduleParams, IAction action) {
        IAction anAction = this.actionFactory.createAction(action);
        if (scheduleParams.getDuration() > 0.0) {
            return new ThreadedAction(scheduleParams, action, this.currentOrderIndex++);
        }
        return new DefaultAction(scheduleParams, anAction, this.currentOrderIndex++);
    }

    @Override
    public ISchedulableAction createAction(ScheduleParameters scheduleParams, Object target, String methodName, Object ... parameters) {
        IAction action = this.actionFactory.createAction(target, methodName, parameters);
        if (scheduleParams.getDuration() > 0.0) {
            return new ThreadedAction(scheduleParams, action, this.currentOrderIndex++);
        }
        return new DefaultAction(scheduleParams, action, this.currentOrderIndex++);
    }

    @Override
    public ISchedulableAction createActionForIterable(ScheduleParameters scheduleParams, Iterable target, String methodName, boolean shuffle, Object ... parameters) {
        IAction action = this.actionFactory.createActionForIterable(target, methodName, shuffle, parameters);
        if (scheduleParams.getDuration() > 0.0) {
            return new ThreadedAction(scheduleParams, action, this.currentOrderIndex++);
        }
        return new DefaultAction(scheduleParams, action, this.currentOrderIndex++);
    }

    @Override
    public ISchedulableAction createAction(Object annotatedObj, Object ... parameters) {
        IActionParameterPair pair = this.actionFactory.createAction(annotatedObj, parameters);
        ScheduleParameters params = pair.getParams();
        if (params.getDuration() > 0.0) {
            return new ThreadedAction(params, pair.getAction(), this.currentOrderIndex++);
        }
        return new DefaultAction(params, pair.getAction(), this.currentOrderIndex++);
    }

    @Override
    public ISchedulableAction createAction(ScheduleParameters scheduleParams, Object annotatedObj, Object ... parameters) {
        IActionParameterPair pair = this.actionFactory.createAction(annotatedObj, parameters);
        if (scheduleParams.getDuration() > 0.0) {
            return new ThreadedAction(scheduleParams, pair.getAction(), this.currentOrderIndex++);
        }
        return new DefaultAction(scheduleParams, pair.getAction(), this.currentOrderIndex++);
    }

    @Override
    public List<ISchedulableAction> createActions(Object obj) {
        ArrayList<ISchedulableAction> actions = new ArrayList<ISchedulableAction>();
        List<IActionParameterPair> pairs = this.actionFactory.createActions(obj);
        for (IActionParameterPair pair : pairs) {
            ScheduleParameters params = pair.getParams();
            if (params.getDuration() > 0.0) {
                actions.add(new ThreadedAction(params, pair.getAction(), this.currentOrderIndex++));
                continue;
            }
            actions.add(new DefaultAction(params, pair.getAction(), this.currentOrderIndex++));
        }
        return actions;
    }

    @Override
    public IActionFactory getActionFactory() {
        return this.actionFactory;
    }
}

