/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.engine.schedule.CallBackAction;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.IActionFactory;
import repast.simphony.engine.schedule.IActionParameterPair;
import repast.simphony.engine.schedule.IterableCallBackAction;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.schedule.ScheduledMethod;
import repast.simphony.util.ClassUtilities;

public class DefaultActionFactory
implements IActionFactory {
    static final long serialVersionUID = 1146802409368283440L;

    @Override
    public IAction createAction(IAction action) {
        return action;
    }

    @Override
    public IAction createAction(Object target, String methodName, Object ... parameters) {
        return new CallBackAction(target, methodName, parameters);
    }

    @Override
    public IAction createActionForIterable(Iterable target, String methodName, boolean shuffle, Object ... parameters) {
        return new IterableCallBackAction(target, methodName, shuffle, parameters);
    }

    @Override
    public IActionParameterPair createAction(Object annotatedObj, Object ... parameters) {
        Class<?> clazz = annotatedObj.getClass();
        Map<String, ScheduleParameters> nameParamMap = this.findCandidateMethodMatches(clazz);
        Class[] paramTypes = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            paramTypes[i] = parameters[i].getClass();
            ++i;
        }
        ArrayList<Method> matches = new ArrayList<Method>();
        for (String name : nameParamMap.keySet()) {
            Method method = ClassUtilities.findMethod(clazz, name, paramTypes);
            if (method == null) continue;
            matches.add(method);
        }
        if (matches.size() != 1) {
            String pTypes = "(";
            int i2 = 0;
            while (i2 < paramTypes.length) {
                if (i2 > 0) {
                    pTypes = String.valueOf(pTypes) + ", ";
                }
                pTypes = String.valueOf(pTypes) + paramTypes[i2].getName();
                ++i2;
            }
            pTypes = String.valueOf(pTypes) + ")";
            if (matches.size() == 0) {
                throw new IllegalArgumentException("Unable to find match for ScheduleMethod annotated object '" + clazz.getName() + "' with method parameters " + pTypes);
            }
            throw new IllegalArgumentException("Too many matches for ScheduleMethod annotated object '" + clazz.getName() + "' with method parameters " + pTypes);
        }
        Method method = (Method)matches.get(0);
        CallBackAction action = new CallBackAction(annotatedObj, method, parameters);
        return new IActionParameterPair(action, nameParamMap.get(method.getName()));
    }

    private Map<String, ScheduleParameters> findCandidateMethodMatches(Class clazz) {
        Method[] methods = clazz.getMethods();
        HashMap<String, ScheduleParameters> nameParamMap = new HashMap<String, ScheduleParameters>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            ScheduledMethod scheduledMethod = ClassUtilities.deepAnnotationCheck(method, ScheduledMethod.class);
            if (scheduledMethod != null) {
                String methodName = method.getName();
                double duration = scheduledMethod.duration();
                ScheduleParameters params = scheduledMethod.interval() > 0.0 ? ScheduleParameters.createRepeating(scheduledMethod.start(), scheduledMethod.interval(), scheduledMethod.priority(), duration) : ScheduleParameters.createOneTime(scheduledMethod.start(), scheduledMethod.priority(), duration);
                nameParamMap.put(methodName, params);
            }
            ++n2;
        }
        return nameParamMap;
    }

    @Override
    public List<IActionParameterPair> createActions(Object obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<IActionParameterPair> actions = new ArrayList<IActionParameterPair>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            ScheduledMethod scheduledMethod = method.getAnnotation(ScheduledMethod.class);
            if (scheduledMethod != null && method.getParameterTypes().length == 0 && scheduledMethod.start() != -1.0) {
                CallBackAction action = new CallBackAction(obj, method);
                double duration = scheduledMethod.duration();
                ScheduleParameters params = scheduledMethod.start() == Double.POSITIVE_INFINITY ? ScheduleParameters.createAtEnd(scheduledMethod.priority()) : (scheduledMethod.interval() > 0.0 ? ScheduleParameters.createRepeating(scheduledMethod.start(), scheduledMethod.interval(), scheduledMethod.priority(), duration) : ScheduleParameters.createOneTime(scheduledMethod.start(), scheduledMethod.priority(), duration));
                actions.add(new IActionParameterPair(action, params));
            }
            ++n2;
        }
        return actions;
    }
}

