/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.util.ClassUtilities;

public class CallBackAction
implements IAction {
    static final long serialVersionUID = 3628821571113796716L;
    private Object target;
    private transient FastMethod method;
    private Object[] args;
    private String methodName;

    public CallBackAction(Object target, Method method) {
        this.args = new Object[method.getParameterTypes().length];
        this.target = target;
        this.method = FastClass.create(target.getClass()).getMethod(method);
        this.methodName = this.method.getName();
    }

    public CallBackAction(Object target, Method method, Object ... parameters) {
        this.args = new Object[parameters.length];
        this.target = target;
        this.method = FastClass.create(target.getClass()).getMethod(method);
        System.arraycopy(parameters, 0, this.args, 0, parameters.length);
        this.methodName = this.method.getName();
    }

    public CallBackAction(Object target, String methodName, Object ... parameters) {
        this.target = target;
        this.methodName = methodName;
        this.args = new Object[parameters.length];
        System.arraycopy(parameters, 0, this.args, 0, parameters.length);
        Class[] paramTypes = new Class[parameters.length];
        int i = 0;
        while (i < this.args.length) {
            paramTypes[i] = this.args[i].getClass();
            ++i;
        }
        this.initMethod(target, methodName, paramTypes);
    }

    private void initMethod(Object target, String methodName, Class[] paramTypes) {
        block5: {
            FastClass fClass = FastClass.create(target.getClass());
            try {
                this.method = fClass.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodError er) {
                Method jMethod = ClassUtilities.findMethod(target.getClass(), methodName, paramTypes);
                if (jMethod == null) break block5;
                this.method = FastClass.create(jMethod.getDeclaringClass()).getMethod(jMethod);
            }
        }
        if (this.method == null) {
            String pTypes = "(";
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    pTypes = String.valueOf(pTypes) + ", ";
                }
                pTypes = String.valueOf(pTypes) + paramTypes[i].getName();
                ++i;
            }
            pTypes = String.valueOf(pTypes) + ")";
            throw new IllegalArgumentException("Method " + target.getClass().getName() + "." + methodName + pTypes + " not found!");
        }
    }

    public void setArgs(int index, Object arg) {
        this.args[index] = arg;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public void execute() {
        try {
            this.method.invoke(this.target, this.args);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Class[] params = new Class[this.args.length];
        int i = 0;
        while (i < this.args.length) {
            params[i] = this.args[i].getClass();
            ++i;
        }
        this.initMethod(this.target, this.methodName, params);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Method getMethod() {
        return this.method.getJavaMethod();
    }

    public FastMethod getFastMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object obj) {
        this.target = obj;
    }
}

