/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import repast.simphony.engine.schedule.ScheduledStatistic;

public enum AggregateScheduledStatistic implements ScheduledStatistic
{
    SUM("Sum"){

        @Override
        public double computeStatistic(Iterable<? extends Number> values) {
            double sum = 0.0;
            for (Number number : values) {
                sum += number.doubleValue();
            }
            return sum;
        }
    }
    ,
    PRODUCT("Product"){

        @Override
        public double computeStatistic(Iterable<? extends Number> values) {
            double prod = 0.0;
            for (Number number : values) {
                prod *= number.doubleValue();
            }
            return prod;
        }
    }
    ,
    MAX("Max"){

        @Override
        public double computeStatistic(Iterable<? extends Number> values) {
            double max = Double.NEGATIVE_INFINITY;
            for (Number number : values) {
                double doubleValue = number.doubleValue();
                if (!(max < doubleValue)) continue;
                max = doubleValue;
            }
            return max;
        }
    }
    ,
    MIN("Min"){

        @Override
        public double computeStatistic(Iterable<? extends Number> values) {
            double min = Double.POSITIVE_INFINITY;
            for (Number number : values) {
                double doubleValue = number.doubleValue();
                if (!(min > doubleValue)) continue;
                min = doubleValue;
            }
            return min;
        }
    }
    ,
    MEAN("Mean"){

        @Override
        public double computeStatistic(Iterable<? extends Number> values) {
            double max = Double.NEGATIVE_INFINITY;
            double min = Double.POSITIVE_INFINITY;
            for (Number number : values) {
                double doubleValue = number.doubleValue();
                if (max < doubleValue) {
                    max = doubleValue;
                }
                if (!(min > doubleValue)) continue;
                min = doubleValue;
            }
            return (max - min) / 2.0;
        }
    };

    public static final String STAT_COMPUTE_METH_NAME = "computeStatistic";
    private String description;

    private AggregateScheduledStatistic(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(String stringVal) {
        return this.description.equalsIgnoreCase(stringVal);
    }

    /* synthetic */ AggregateScheduledStatistic(String string, int n, String string2, AggregateScheduledStatistic aggregateScheduledStatistic) {
        this(string2);
    }
}

