/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.util.NoSuchElementException;
import repast.simphony.engine.schedule.AbstractAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ScheduleGroup;
import repast.simphony.engine.schedule.ScheduleParameters;

public class ActionQueue {
    static final long serialVersionUID = -5594830901668228513L;
    private int maxSize;
    private int origMax;
    private int currentSize = 0;
    private boolean orderOk = true;
    private int modelActionCount = 0;
    private ISchedulableAction[] array;

    public ActionQueue() {
        this(13);
    }

    public ActionQueue(int size) {
        this.maxSize = size;
        this.origMax = size;
        this.allocateArray(size);
        DummyAction root = new DummyAction();
        this.array[0] = root;
    }

    private void checkSize() {
        if (this.currentSize == this.maxSize) {
            ISchedulableAction[] old = this.array;
            this.allocateArray(this.maxSize * 2);
            System.arraycopy(old, 0, this.array, 0, old.length);
            old = null;
            this.maxSize *= 2;
        }
    }

    private void percolateDown(int hole) {
        if (this.currentSize > 0) {
            ISchedulableAction tmp = this.array[hole];
            while (hole * 2 <= this.currentSize) {
                int child = hole * 2;
                if (child != this.currentSize && this.array[child + 1].getNextTime() < this.array[child].getNextTime()) {
                    ++child;
                }
                if (!(this.array[child].getNextTime() < tmp.getNextTime())) break;
                this.array[hole] = this.array[child];
                hole = child;
            }
            this.array[hole] = tmp;
        }
    }

    public boolean voidAction(ISchedulableAction action) {
        boolean found = false;
        int i = 0;
        int n = this.array.length;
        while (i < n) {
            if (action.equals(this.array[i])) {
                this.array[i] = new EmptyAction(action.getNextTime());
                if (!action.isNonModelAction()) {
                    --this.modelActionCount;
                }
                found = true;
            }
            ++i;
        }
        return found;
    }

    public void insert(ISchedulableAction action) {
        if (!this.orderOk) {
            this.toss(action);
            return;
        }
        this.checkSize();
        int hole = ++this.currentSize;
        if (hole != 1) {
            while (action.getNextTime() < this.array[hole / 2].getNextTime()) {
                this.array[hole] = this.array[hole / 2];
                hole /= 2;
            }
        }
        this.array[hole] = action;
        if (!action.isNonModelAction()) {
            ++this.modelActionCount;
        }
    }

    public ISchedulableAction peekMin() {
        if (this.currentSize == 0) {
            throw new NoSuchElementException("Queue is Empty");
        }
        if (!this.orderOk) {
            this.fixHeap();
        }
        return this.array[1];
    }

    public ISchedulableAction popMin() {
        ISchedulableAction a = this.peekMin();
        ISchedulableAction tmp = this.array[this.currentSize];
        this.array[this.currentSize] = null;
        --this.currentSize;
        if (this.currentSize > 0) {
            this.array[1] = tmp;
            this.percolateDown(1);
        }
        if (!a.isNonModelAction()) {
            --this.modelActionCount;
        }
        return a;
    }

    public void toss(ISchedulableAction action) {
        this.checkSize();
        this.array[++this.currentSize] = action;
        if (this.currentSize != 1 && action.getNextTime() < this.array[this.currentSize / 2].getNextTime()) {
            this.orderOk = false;
        }
        if (!action.isNonModelAction()) {
            ++this.modelActionCount;
        }
    }

    public void clear() {
        this.currentSize = 0;
        this.orderOk = true;
        this.allocateArray(this.origMax);
        this.maxSize = this.origMax;
        DummyAction root = new DummyAction();
        this.array[0] = root;
        this.modelActionCount = 0;
    }

    public void fixHeap() {
        int i = this.currentSize / 2;
        while (i > 0) {
            this.percolateDown(i);
            --i;
        }
        this.orderOk = true;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public int size() {
        return this.currentSize;
    }

    public int getModelActionCount() {
        return this.modelActionCount;
    }

    private void allocateArray(int newMaxSize) {
        this.array = new AbstractAction[newMaxSize + 1];
    }

    static class DummyAction
    extends AbstractAction {
        private static final long serialVersionUID = -5139789622934288912L;

        DummyAction() {
            super(ScheduleParameters.createOneTime(Double.NEGATIVE_INFINITY));
        }

        @Override
        public void execute() {
        }

        public void setPriority(double priority) {
        }
    }

    static class EmptyAction
    extends AbstractAction {
        private static final long serialVersionUID = -830235028902826597L;

        EmptyAction(double nextTime) {
            super(ScheduleParameters.createOneTime(nextTime));
        }

        @Override
        public void execute() {
        }

        @Override
        public void addForExecution(ScheduleGroup group) {
        }

        @Override
        public boolean isNonModelAction() {
            return true;
        }

        public void setPriority(double priority) {
        }
    }
}

