/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.random.RandomHelper;
import repast.simphony.util.SimUtilities;

public class ActionList
implements Iterable<ISchedulableAction> {
    private List<ISchedulableAction> list = new ArrayList<ISchedulableAction>();
    private boolean dirty = false;

    public void clear() {
        this.list.clear();
        this.dirty = false;
    }

    public void add(ISchedulableAction action) {
        this.dirty = true;
        this.list.add(action);
    }

    public void addNoSort(ISchedulableAction action) {
        this.list.add(action);
    }

    public void addNoSort(int index, ISchedulableAction action) {
        this.list.add(index, action);
    }

    public void addAllNoSort(ActionList other) {
        this.list.addAll(other.list);
    }

    public boolean remove(ISchedulableAction action) {
        return this.list.remove(action);
    }

    public int size() {
        return this.list.size();
    }

    public void shuffle() {
        SimUtilities.shuffle(this.list, RandomHelper.getUniform());
    }

    public void sort(Comparator<ISchedulableAction> comp, boolean force) {
        if (this.dirty || force) {
            Collections.sort(this.list, comp);
            this.dirty = false;
        }
    }

    @Override
    public Iterator<ISchedulableAction> iterator() {
        return this.list.iterator();
    }

    public void delete(int n) {
        if (n == this.list.size()) {
            this.list.clear();
        } else {
            this.list.subList(0, n).clear();
        }
    }
}

