/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.schedule;

import repast.simphony.engine.schedule.ActionQueue;
import repast.simphony.engine.schedule.Frequency;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.NonModelAction;
import repast.simphony.engine.schedule.PriorityType;
import repast.simphony.engine.schedule.ScheduleGroup;
import repast.simphony.engine.schedule.ScheduleParameters;

public abstract class AbstractAction
implements ISchedulableAction {
    static final long serialVersionUID = -7327096371080222392L;
    protected Frequency frequency = Frequency.REPEAT;
    protected double nextTime = Double.NaN;
    protected PriorityType pType;
    protected double interval = 1.0;
    protected double priority = Double.NaN;
    protected boolean nonModelAction;
    private long index = 0L;
    protected Rescheduler rescheduler = new IntervalRescheduler();

    public AbstractAction(ScheduleParameters params, long orderIndex) {
        this(params);
        this.index = orderIndex;
    }

    public AbstractAction(ScheduleParameters params) {
        this.setFrequency(params.getFrequency());
        this.nextTime = params.getStart();
        this.priority = params.getPriority();
        this.interval = params.getInterval();
        this.pType = params.getPriorityType();
    }

    @Override
    public double getNextTime() {
        return this.nextTime;
    }

    protected void setIsNonModelAction(IAction action) {
        this.nonModelAction = action.getClass().isAnnotationPresent(NonModelAction.class);
    }

    protected void setIsNonModelAction(boolean nonModelAction) {
        this.nonModelAction = nonModelAction;
    }

    @Override
    public boolean isNonModelAction() {
        return this.nonModelAction;
    }

    protected void setFrequency(Frequency freq) {
        this.frequency = freq;
        if (freq == Frequency.REPEAT) {
            this.rescheduler = new IntervalRescheduler();
        } else if (freq == Frequency.ONE_TIME) {
            this.rescheduler = new OneTimeRescheduler();
        }
    }

    @Override
    public void reschedule(ActionQueue queue) {
        this.rescheduler.reschedule(queue);
    }

    @Override
    public void addForExecution(ScheduleGroup group) {
        group.addAction(this);
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    @Override
    public PriorityType getPriorityType() {
        return this.pType;
    }

    @Override
    public long getOrderIndex() {
        return this.index;
    }

    protected class IntervalRescheduler
    implements Rescheduler {
        private static final long serialVersionUID = 6596470668793932788L;

        protected IntervalRescheduler() {
        }

        @Override
        public void reschedule(ActionQueue queue) {
            AbstractAction.this.nextTime += AbstractAction.this.interval;
            queue.toss(AbstractAction.this);
        }
    }

    protected static class OneTimeRescheduler
    implements Rescheduler {
        private static final long serialVersionUID = 6926888495853469259L;

        protected OneTimeRescheduler() {
        }

        @Override
        public void reschedule(ActionQueue queue) {
        }
    }

    protected static interface Rescheduler {
        public void reschedule(ActionQueue var1);
    }
}

