/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.graph;

import java.util.Iterator;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.iterators.FilterIterator;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.graph.Traverser;

public class NetworkTraverser<T>
implements Traverser<T> {
    private Network<T> network;

    public NetworkTraverser(Network<T> topology) {
        this.network = topology;
    }

    @Override
    public Iterator<T> getSuccessors(final T previousNode, T currentNode) {
        return new FilterIterator(this.network.getSuccessors(currentNode).iterator(), new Predicate<T>(){

            public boolean evaluate(T toCheck) {
                return toCheck != previousNode;
            }
        });
    }

    @Override
    public double getDistance(T previousNode, T currentNode) {
        RepastEdge<T> edge = this.network.getEdge(previousNode, currentNode);
        if (edge == null) {
            return Double.POSITIVE_INFINITY;
        }
        return edge.getWeight();
    }
}

