/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.graph;

import java.util.Iterator;
import repast.simphony.space.graph.Traverser;
import repast.simphony.util.collections.NaryTree;

public class NaryTreeTraverser<T>
implements Traverser<T> {
    protected NaryTree<T> tree;
    protected boolean simpleDistance;

    public NaryTreeTraverser() {
    }

    public NaryTreeTraverser(NaryTree<T> tree, boolean simpleDistance) {
        this.tree = tree;
        this.simpleDistance = simpleDistance;
    }

    public NaryTreeTraverser(NaryTree<T> tree) {
        this(tree, true);
        this.tree = tree;
    }

    @Override
    public Iterator<T> getSuccessors(T previousNode, T currentNode) {
        return this.tree.getChildren(currentNode).iterator();
    }

    @Override
    public double getDistance(T fromNode, T toNode) {
        if (this.simpleDistance || this.tree.getChildren(fromNode).contains(toNode)) {
            return 1.0;
        }
        return Double.POSITIVE_INFINITY;
    }
}

