/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.graph;

import java.util.Iterator;
import repast.simphony.space.graph.Traverser;

public class IterableTraverser<T>
implements Traverser<T> {
    private Iterator<T> iterator;
    private static final Iterator NULL_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    private final ValueIterator valueIterator = new ValueIterator();
    private double defaultDistance = 1.0;

    public IterableTraverser(Iterable<T> iterable) {
        this(iterable.iterator(), true);
    }

    public IterableTraverser(Iterable<T> iterable, boolean skipFirst) {
        this(iterable.iterator(), skipFirst);
    }

    public IterableTraverser(Iterator<T> iterator) {
        this(iterator, true);
    }

    public IterableTraverser(Iterator<T> iterator, boolean skipFirst) {
        this.iterator = iterator;
        if (skipFirst) {
            this.skipFirst();
        }
    }

    private void skipFirst() {
        if (this.iterator.hasNext()) {
            this.iterator.next();
        }
    }

    @Override
    public Iterator<T> getSuccessors(T previousNode, T currentNode) {
        if (this.iterator.hasNext()) {
            this.valueIterator.value = this.iterator.next();
            return this.valueIterator;
        }
        return NULL_ITERATOR;
    }

    @Override
    public double getDistance(T fromNode, T toNode) {
        return this.defaultDistance;
    }

    public void setDefaultDistance(double defaultDistance) {
        this.defaultDistance = defaultDistance;
    }

    private class ValueIterator
    implements Iterator<T> {
        public T value;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.value != null;
        }

        @Override
        public T next() {
            Object valTmp = this.value;
            this.value = null;
            return valTmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove unsupported");
        }
    }
}

