/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.graph;

import repast.simphony.engine.graph.Executor;
import repast.simphony.engine.graph.GraphParams;
import repast.simphony.engine.graph.NetworkTopologyExecutor;
import repast.simphony.engine.graph.NetworkTraverser;
import repast.simphony.engine.schedule.Frequency;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.space.graph.Network;
import simphony.util.messages.MessageCenter;

public class GraphScheduleUtilities {
    private static final MessageCenter l4jLogger = MessageCenter.getMessageCenter(GraphScheduleUtilities.class);

    public static <E> ISchedulableAction scheduleGraph(ISchedule schedule, ScheduleParameters baseParams, Object rootNode, Executor<GraphParams<E>> graphExecutor) {
        return schedule.schedule((Object)baseParams, graphExecutor, new GraphParams<Object>(null, rootNode, 0.0));
    }

    public static ISchedulableAction scheduleGraph(ISchedule schedule, ScheduleParameters baseParams, Object rootNode, Network topology, Executor<Object> nodeExecutor) {
        return GraphScheduleUtilities.scheduleGraph(schedule, baseParams, rootNode, new NetworkTopologyExecutor(schedule, baseParams, new NetworkTraverser<Object>(topology), nodeExecutor, topology));
    }

    public static ScheduleParameters getSimilarParams(ScheduleParameters baseParameters, double newTime) {
        return GraphScheduleUtilities.getSimilarParams(baseParameters, newTime, baseParameters.getFrequency(), baseParameters.getInterval());
    }

    public static ScheduleParameters getSimilarOneTimeParams(ScheduleParameters baseParameters, double newTime) {
        return GraphScheduleUtilities.getSimilarParams(baseParameters, newTime, Frequency.ONE_TIME, 0.0);
    }

    public static ScheduleParameters getSimilarParams(ScheduleParameters baseParameters, double newTime, Frequency frequency, double interval) {
        switch (frequency) {
            case ONE_TIME: {
                return ScheduleParameters.createOneTime(newTime, baseParameters.getPriority(), baseParameters.getDuration());
            }
            case REPEAT: {
                return ScheduleParameters.createRepeating(baseParameters.getStart() + newTime, interval, baseParameters.getPriority(), baseParameters.getDuration());
            }
        }
        l4jLogger.warn((Object)"Utilities.getNextScheduleParameters: Unknown Frequency type found when attempting to get next schedule parameters.", new Object[0]);
        return null;
    }
}

