/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.graph;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.collections15.Predicate;
import repast.simphony.engine.graph.Executor;
import repast.simphony.space.graph.Traverser;

public class EngineGraphUtilities {
    public static <T> void breadthFirstMap(Executor<T> visitor, Traverser<T> traverser, T root) {
        EngineGraphUtilities.breadthFirstSearch(new MapPredicate<T>(visitor), traverser, root);
    }

    public static <T> T breadthFirstSearch(Predicate<T> checker, Traverser<T> traverser, T root) {
        LinkedList<T> queue = new LinkedList<T>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Object node = queue.remove();
            if (checker.evaluate(node)) {
                return (T)node;
            }
            Iterator<Object> iter = traverser.getSuccessors(null, node);
            while (iter.hasNext()) {
                queue.add(iter.next());
            }
        }
        return null;
    }

    private static class MapPredicate<T>
    implements Predicate<T> {
        private static final long serialVersionUID = -8855984562901493039L;
        private Executor<T> executor;

        public MapPredicate(Executor<T> executor) {
            this.executor = executor;
        }

        public boolean evaluate(T toCheck) {
            this.executor.execute(toCheck);
            return false;
        }
    }
}

