/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.engine.graph;

import java.util.Iterator;
import repast.simphony.engine.graph.Executor;
import repast.simphony.engine.graph.GraphExecutor;
import repast.simphony.engine.graph.GraphParams;
import repast.simphony.engine.graph.GraphScheduleUtilities;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.engine.schedule.ScheduledMethod;
import repast.simphony.space.graph.Traverser;
import repast.simphony.util.SimUtilities;

public abstract class AbstractGraphExecutor<E>
implements GraphExecutor<E> {
    private Traverser<E> traverser;
    private Executor<E> nodeExecutor;
    private ISchedule schedule;
    private ScheduleParameters baseParams;

    public AbstractGraphExecutor(ISchedule schedule, ScheduleParameters baseParams, Traverser<E> traverser, Executor<E> nodeExecutor) {
        this.schedule = schedule;
        this.baseParams = baseParams;
        this.traverser = traverser;
        this.nodeExecutor = nodeExecutor;
    }

    @Override
    @ScheduledMethod
    public void execute(GraphParams<E> params) {
        if (params.getPreviousNode() == null || this.validateForExecution(params)) {
            this.nodeExecutor.execute(params.getCurrentNode());
            Iterator<E> iter = this.traverser.getSuccessors(params.getPreviousNode(), params.getCurrentNode());
            while (iter.hasNext()) {
                E successor = iter.next();
                double totalDist = this.getNextTime(params, successor);
                ScheduleParameters scheduleParams = this.getScheduleParameters(totalDist);
                GraphParams<E> graphParams = new GraphParams<E>(params.getCurrentNode(), successor, totalDist - this.getRootTime());
                this.schedule.schedule((Object)scheduleParams, this, graphParams);
            }
        }
    }

    protected ScheduleParameters getScheduleParameters(double time) {
        return GraphScheduleUtilities.getSimilarOneTimeParams(this.baseParams, SimUtilities.scale(time, 7));
    }

    protected double getNextTime(GraphParams<E> params, E nextNode) {
        return this.getRootTime() + params.getPreviousDistance() + this.traverser.getDistance(params.getCurrentNode(), nextNode);
    }

    protected double getRootTime() {
        return this.baseParams.getStart();
    }
}

